/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.block_rendering.BlockMaterialMapping;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gbuffer_overrides.matching.ProgramTable;
import net.coderbot.iris.gbuffer_overrides.matching.RenderCondition;
import net.coderbot.iris.gbuffer_overrides.matching.SpecialCondition;
import net.coderbot.iris.gbuffer_overrides.state.RenderTargetStateListener;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestOverride;
import net.coderbot.iris.gl.blending.AlphaTestStorage;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.HorizonRenderer;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.patcher.AttributeShaderTransformer;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramFallbackResolver;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import org.jetbrains.annotations.Nullable;

public class DeferredWorldRenderingPipeline
implements WorldRenderingPipeline,
RenderTargetStateListener {
    private final RenderTargets renderTargets;
    @Nullable
    private ShadowRenderTargets shadowRenderTargets;
    private final Supplier<ShadowRenderTargets> shadowTargetsSupplier;
    private final ProgramTable<Pass> table;
    private final ImmutableList<ClearPass> clearPassesFull;
    private final ImmutableList<ClearPass> clearPasses;
    private final GlFramebuffer baseline;
    private final CompositeRenderer prepareRenderer;
    @Nullable
    private final ShadowRenderer shadowRenderer;
    private final int shadowMapResolution;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final AbstractTexture whitePixel;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final ImmutableSet<Integer> flippedBeforeShadow;
    private final ImmutableSet<Integer> flippedAfterPrepare;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    private final SodiumTerrainPipeline sodiumTerrainPipeline;
    private final HorizonRenderer horizonRenderer = new HorizonRenderer();
    private final float sunPathRotation;
    private final boolean shouldRenderClouds;
    private final boolean shouldRenderUnderwaterOverlay;
    private final boolean shouldRenderVignette;
    private final boolean shouldWriteRainAndSnowToDepthBuffer;
    private final boolean shouldRenderParticlesBeforeDeferred;
    private final boolean oldLighting;
    private final OptionalInt forcedShadowRenderDistanceChunks;
    private Pass current = null;
    private WorldRenderingPhase overridePhase = null;
    private WorldRenderingPhase phase = WorldRenderingPhase.NONE;
    private boolean isBeforeTranslucent;
    private InputAvailability inputs = new InputAvailability(false, false, false);
    private SpecialCondition special = null;
    private boolean isPostChain;
    private boolean isMainBound = true;
    private boolean isRenderingWorld = false;
    private boolean isRenderingFullScreenPass = false;
    boolean sodiumTerrainRendering = false;
    private boolean isRenderingShadow = false;

    public DeferredWorldRenderingPipeline(ProgramSet programs) {
        Objects.requireNonNull(programs);
        this.shouldRenderClouds = programs.getPackDirectives().areCloudsEnabled();
        this.shouldRenderUnderwaterOverlay = programs.getPackDirectives().underwaterOverlay();
        this.shouldRenderVignette = programs.getPackDirectives().vignette();
        this.shouldWriteRainAndSnowToDepthBuffer = programs.getPackDirectives().rainDepth();
        this.shouldRenderParticlesBeforeDeferred = programs.getPackDirectives().areParticlesBeforeDeferred();
        this.oldLighting = programs.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        RenderTarget mainTarget = Minecraft.m_91087_().m_91385_();
        int depthTextureId = mainTarget.m_83980_();
        int internalFormat = TextureInfoCache.INSTANCE.getInfo(depthTextureId).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(internalFormat);
        this.renderTargets = new RenderTargets(mainTarget.f_83915_, mainTarget.f_83916_, depthTextureId, ((Blaze3dRenderTargetExt)mainTarget).iris$getDepthBufferVersion(), depthBufferFormat, programs.getPackDirectives().getRenderTargetDirectives().getRenderTargetSettings());
        this.sunPathRotation = programs.getPackDirectives().getSunPathRotation();
        PackShadowDirectives shadowDirectives = programs.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = shadowDirectives.isDistanceRenderMulExplicit() ? ((double)shadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(shadowDirectives.getDistance() * shadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        BlockRenderingSettings.INSTANCE.setBlockStateIds(BlockMaterialMapping.createBlockStateIdMap(programs.getPack().getIdMap().getBlockProperties()));
        BlockRenderingSettings.INSTANCE.setBlockTypeIds(BlockMaterialMapping.createBlockTypeMap(programs.getPack().getIdMap().getBlockRenderTypeMap()));
        BlockRenderingSettings.INSTANCE.setEntityIds(programs.getPack().getIdMap().getEntityIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programs.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programs.getPackDirectives().shouldUseSeparateAo());
        BlockRenderingSettings.INSTANCE.setUseExtendedVertexFormat(true);
        GlStateManager.m_84514_((int)33986);
        this.customTextureManager = new CustomTextureManager(programs.getPackDirectives(), programs.getPack().getCustomTextureDataMap(), programs.getPack().getCustomNoiseTexture());
        this.whitePixel = new NativeImageBackedSingleColorTexture(255, 255, 255, 255);
        GlStateManager.m_84514_((int)33984);
        this.flippedBeforeShadow = ImmutableSet.of();
        BufferFlipper flipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(programs.getPackDirectives().getCenterDepthHalfLife());
        this.shadowMapResolution = programs.getPackDirectives().getShadowDirectives().getResolution();
        this.shadowTargetsSupplier = () -> {
            if (this.shadowRenderTargets == null) {
                this.shadowRenderTargets = new ShadowRenderTargets(this.shadowMapResolution, new InternalTextureFormat[]{InternalTextureFormat.RGBA, InternalTextureFormat.RGBA});
            }
            return this.shadowRenderTargets;
        };
        this.prepareRenderer = new CompositeRenderer(programs.getPackDirectives(), programs.getPrepare(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.PREPARE), programs.getPackDirectives().getExplicitFlips("prepare_pre"));
        this.flippedAfterPrepare = flipper.snapshot();
        this.deferredRenderer = new CompositeRenderer(programs.getPackDirectives(), programs.getDeferred(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.DEFERRED), programs.getPackDirectives().getExplicitFlips("deferred_pre"));
        this.flippedAfterTranslucent = flipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(programs.getPackDirectives(), programs.getComposite(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.COMPOSITE_AND_FINAL), programs.getPackDirectives().getExplicitFlips("composite_pre"));
        this.finalPassRenderer = new FinalPassRenderer(programs, this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, flipper.snapshot(), this.centerDepthSampler, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.COMPOSITE_AND_FINAL), this.compositeRenderer.getFlippedAtLeastOnceFinal());
        ProgramId[] ids = new ProgramId[]{ProgramId.Basic, ProgramId.Textured, ProgramId.TexturedLit, ProgramId.SkyBasic, ProgramId.SkyTextured, ProgramId.SkyTextured, null, null, ProgramId.Terrain, null, null, ProgramId.Water, null, ProgramId.Clouds, ProgramId.Clouds, null, ProgramId.DamagedBlock, ProgramId.DamagedBlock, ProgramId.Block, ProgramId.Block, ProgramId.Block, ProgramId.BeaconBeam, ProgramId.BeaconBeam, ProgramId.BeaconBeam, ProgramId.Entities, ProgramId.Entities, ProgramId.Entities, null, ProgramId.ArmorGlint, ProgramId.ArmorGlint, null, ProgramId.SpiderEyes, ProgramId.SpiderEyes, ProgramId.Hand, ProgramId.Hand, ProgramId.Hand, ProgramId.HandWater, ProgramId.HandWater, ProgramId.HandWater, null, null, ProgramId.Weather, null, ProgramId.TexturedLit, ProgramId.TexturedLit, ProgramId.Shadow, ProgramId.Shadow, ProgramId.Shadow};
        if (ids.length != RenderCondition.values().length * 3) {
            throw new IllegalStateException("Program ID table length mismatch");
        }
        ProgramFallbackResolver resolver = new ProgramFallbackResolver(programs);
        HashMap cachedPasses = new HashMap();
        this.table = new ProgramTable<Pass>((condition, availability) -> {
            int idx = availability.texture && availability.lightmap ? 2 : (availability.texture ? 1 : 0);
            ProgramId id = ids[condition.ordinal() * 3 + idx];
            if (id == null) {
                id = ids[idx];
            }
            return cachedPasses.computeIfAbsent(new Pair((Object)id, availability), p -> {
                ProgramSource source = resolver.resolveNullable((ProgramId)((Object)((Object)((Object)p.getFirst()))));
                if (condition == RenderCondition.SHADOW) {
                    if (this.shadowRenderTargets == null) {
                        return null;
                    }
                    if (source == null) {
                        GlFramebuffer shadowFb = this.shadowRenderTargets.getFramebuffer();
                        return new Pass(null, shadowFb, shadowFb, null, BlendModeOverride.OFF, true);
                    }
                }
                if (source == null) {
                    return this.createDefaultPass();
                }
                return this.createPass(source, (InputAvailability)availability, condition == RenderCondition.SHADOW);
            });
        });
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programs.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programs.getPackDirectives().getRenderTargetDirectives());
        this.baseline = this.renderTargets.createGbufferFramebuffer((ImmutableSet<Integer>)ImmutableSet.of(), new int[]{0});
        if (this.shadowRenderTargets != null) {
            Program shadowProgram = this.table.match(RenderCondition.SHADOW, new InputAvailability(true, true, true)).getProgram();
            boolean shadowUsesImages = shadowProgram != null && shadowProgram.getActiveImages() > 0;
            this.shadowRenderer = new ShadowRenderer(programs.getShadow().orElse(null), programs.getPackDirectives(), this.shadowRenderTargets, shadowUsesImages);
        } else {
            this.shadowRenderer = null;
        }
        Supplier<ImmutableSet> flipped = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> createTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(TextureStage.GBUFFERS_AND_SHADOW));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (AbstractTexture)this.customTextureManager.getNormals(), (AbstractTexture)this.customTextureManager.getSpecular(), this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramImages> createTerrainImages = programId -> {
            ProgramImages.Builder builder = ProgramImages.builder(programId);
            IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramSamplers> createShadowTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(TextureStage.GBUFFERS_AND_SHADOW));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> this.flippedAfterPrepare, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (AbstractTexture)this.customTextureManager.getNormals(), (AbstractTexture)this.customTextureManager.getSpecular(), this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        IntFunction<ProgramImages> createShadowTerrainImages = programId -> {
            ProgramImages.Builder builder = ProgramImages.builder(programId);
            IrisImages.addRenderTargetImages(builder, () -> this.flippedAfterPrepare, this.renderTargets);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets));
            }
            return builder.build();
        };
        this.sodiumTerrainPipeline = new SodiumTerrainPipeline(this, programs, createTerrainSamplers, this.shadowRenderTargets == null ? null : createShadowTerrainSamplers, createTerrainImages, createShadowTerrainImages, this.renderTargets, this.flippedAfterPrepare, this.flippedAfterTranslucent, this.shadowRenderTargets != null ? this.shadowRenderTargets.getFramebuffer() : null);
    }

    private void checkWorld() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            this.isRenderingWorld = false;
            this.current = null;
        }
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return this.shadowRenderer != null;
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public boolean shouldRenderClouds() {
        return this.shouldRenderClouds;
    }

    @Override
    public boolean shouldRenderUnderwaterOverlay() {
        return this.shouldRenderUnderwaterOverlay;
    }

    @Override
    public boolean shouldRenderVignette() {
        return this.shouldRenderVignette;
    }

    @Override
    public boolean shouldWriteRainAndSnowToDepthBuffer() {
        return this.shouldWriteRainAndSnowToDepthBuffer;
    }

    @Override
    public boolean shouldRenderParticlesBeforeDeferred() {
        return this.shouldRenderParticlesBeforeDeferred;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    private RenderCondition getCondition(WorldRenderingPhase phase) {
        if (this.isRenderingShadow) {
            return RenderCondition.SHADOW;
        }
        if (this.special != null) {
            if (this.special == SpecialCondition.BEACON_BEAM) {
                return RenderCondition.BEACON_BEAM;
            }
            if (this.special == SpecialCondition.ENTITY_EYES) {
                return RenderCondition.ENTITY_EYES;
            }
            if (this.special == SpecialCondition.GLINT) {
                return RenderCondition.GLINT;
            }
        }
        switch (phase) {
            case NONE: 
            case OUTLINE: 
            case DEBUG: 
            case PARTICLES: {
                return RenderCondition.DEFAULT;
            }
            case SKY: 
            case SUNSET: 
            case CUSTOM_SKY: 
            case SUN: 
            case MOON: 
            case STARS: 
            case VOID: {
                return RenderCondition.SKY;
            }
            case TERRAIN_SOLID: 
            case TERRAIN_CUTOUT: 
            case TERRAIN_CUTOUT_MIPPED: {
                return RenderCondition.TERRAIN_OPAQUE;
            }
            case ENTITIES: {
                return RenderCondition.ENTITIES;
            }
            case BLOCK_ENTITIES: {
                return RenderCondition.BLOCK_ENTITIES;
            }
            case DESTROY: {
                return RenderCondition.DESTROY;
            }
            case HAND_SOLID: {
                return RenderCondition.HAND_OPAQUE;
            }
            case TERRAIN_TRANSLUCENT: 
            case TRIPWIRE: {
                return RenderCondition.TERRAIN_TRANSLUCENT;
            }
            case CLOUDS: {
                return RenderCondition.CLOUDS;
            }
            case RAIN_SNOW: {
                return RenderCondition.RAIN_SNOW;
            }
            case HAND_TRANSLUCENT: {
                return RenderCondition.HAND_TRANSLUCENT;
            }
            case WORLD_BORDER: {
                return RenderCondition.WORLD_BORDER;
            }
        }
        throw new IllegalStateException("Unknown render phase " + phase);
    }

    private void matchPass() {
        if (!this.isRenderingWorld || this.isRenderingFullScreenPass || this.isPostChain || !this.isMainBound) {
            return;
        }
        if (this.sodiumTerrainRendering) {
            this.beginPass(this.table.match(this.getCondition(this.getPhase()), new InputAvailability(true, true, false)));
            return;
        }
        this.beginPass(this.table.match(this.getCondition(this.getPhase()), this.inputs));
    }

    public void beginPass(Pass pass) {
        if (this.current == pass) {
            return;
        }
        if (this.current != null) {
            this.current.stopUsing();
        }
        this.current = pass;
        if (pass != null) {
            pass.use();
        } else {
            Program.unbind();
        }
    }

    private Pass createDefaultPass() {
        GlFramebuffer framebufferBeforeTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, new int[]{0});
        GlFramebuffer framebufferAfterTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, new int[]{0});
        return new Pass(null, framebufferBeforeTranslucents, framebufferAfterTranslucents, null, null, false);
    }

    private Pass createPass(ProgramSource source, InputAvailability availability, boolean shadow) {
        ProgramBuilder builder;
        String geometry;
        String vertex = AttributeShaderTransformer.patch(source.getVertexSource().orElseThrow(NullPointerException::new), ShaderType.VERTEX, (geometry = (String)source.getGeometrySource().orElse(null)) != null, availability);
        String fragment = AttributeShaderTransformer.patch(source.getFragmentSource().orElseThrow(NullPointerException::new), ShaderType.FRAGMENT, geometry != null, availability);
        try {
            builder = ProgramBuilder.begin(source.getName(), vertex, geometry, fragment, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Shader compilation failed!", e);
        }
        return this.createPassInner(builder, source.getParent().getPack().getIdMap(), source.getDirectives(), source.getParent().getPackDirectives(), availability, shadow);
    }

    private Pass createPassInner(ProgramBuilder builder, IdMap map, ProgramDirectives programDirectives, PackDirectives packDirectives, InputAvailability availability, boolean shadow) {
        GlFramebuffer framebufferAfterTranslucents;
        GlFramebuffer framebufferBeforeTranslucents;
        CommonUniforms.addCommonUniforms(builder, map, packDirectives, this.updateNotifier, null);
        Supplier<Object> flipped = shadow ? () -> this.flippedBeforeShadow : () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(textureStage));
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
        IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
        IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (AbstractTexture)this.customTextureManager.getNormals(), (AbstractTexture)this.customTextureManager.getSpecular(), this.whitePixel, availability);
        if (!shadow) {
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
        }
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            if (!shadow) {
                this.shadowTargetsSupplier.get();
            }
            if (this.shadowRenderTargets != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowRenderTargets);
                IrisImages.addShadowColorImages(builder, this.shadowRenderTargets);
            }
        }
        if (shadow) {
            framebufferAfterTranslucents = framebufferBeforeTranslucents = Objects.requireNonNull(this.shadowRenderTargets).getFramebuffer();
        } else {
            framebufferBeforeTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, programDirectives.getDrawBuffers());
            framebufferAfterTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, programDirectives.getDrawBuffers());
        }
        builder.bindAttributeLocation(11, "mc_Entity");
        builder.bindAttributeLocation(12, "mc_midTexCoord");
        builder.bindAttributeLocation(13, "at_tangent");
        AlphaTest alphaTestOverride = programDirectives.getAlphaTestOverride().orElse(null);
        return new Pass(builder.build(), framebufferBeforeTranslucents, framebufferAfterTranslucents, alphaTestOverride, programDirectives.getBlendModeOverride(), shadow);
    }

    @Override
    public void beginPostChain() {
        this.isPostChain = true;
        this.beginPass(null);
    }

    @Override
    public void endPostChain() {
        this.isPostChain = false;
    }

    @Override
    public void setIsMainBound(boolean bound) {
        this.isMainBound = bound;
        if (!this.isRenderingWorld || this.isRenderingFullScreenPass || this.isPostChain) {
            return;
        }
        if (bound) {
            this.current = null;
        } else {
            this.beginPass(null);
        }
    }

    @Override
    public void destroy() {
        BlendModeOverride.restore();
        AlphaTestOverride.restore();
        DeferredWorldRenderingPipeline.destroyPasses(this.table);
        this.compositeRenderer.destroy();
        this.deferredRenderer.destroy();
        this.finalPassRenderer.destroy();
        this.centerDepthSampler.destroy();
        GlStateManager.m_84486_((int)36008, (int)0);
        GlStateManager.m_84486_((int)36009, (int)0);
        GlStateManager.m_84486_((int)36160, (int)0);
        Minecraft.m_91087_().m_91385_().m_83947_(false);
        this.renderTargets.destroy();
        if (this.shadowRenderTargets != null) {
            this.shadowRenderTargets.destroy();
        }
        this.customTextureManager.destroy();
        this.whitePixel.m_117964_();
    }

    private static void destroyPasses(ProgramTable<Pass> table) {
        HashSet destroyed = new HashSet();
        table.forEach(pass -> {
            if (pass == null) {
                return;
            }
            if (destroyed.contains(pass)) {
                return;
            }
            pass.destroy();
            destroyed.add(pass);
        });
    }

    private void prepareRenderTargets() {
        ImmutableList<ClearPass> passes;
        RenderSystem.m_69388_((int)33984);
        if (this.shadowRenderTargets != null) {
            this.shadowRenderTargets.getFramebuffer().bind();
            RenderSystem.m_69424_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69430_((double)1.0);
            RenderSystem.m_69421_((int)16640, (boolean)false);
        }
        RenderTarget main = Minecraft.m_91087_().m_91385_();
        Blaze3dRenderTargetExt mainExt = (Blaze3dRenderTargetExt)main;
        int depthTextureId = main.m_83980_();
        int internalFormat = TextureInfoCache.INSTANCE.getInfo(depthTextureId).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(internalFormat);
        this.renderTargets.resizeIfNeeded(mainExt.iris$getDepthBufferVersion(), depthTextureId, main.f_83915_, main.f_83916_, depthBufferFormat);
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            passes = this.clearPassesFull;
        } else {
            passes = this.clearPasses;
        }
        Vector3d fogColor3 = CapturedRenderingState.INSTANCE.getFogColor();
        Vector4f fogColor = new Vector4f((float)fogColor3.x, (float)fogColor3.y, (float)fogColor3.z, 1.0f);
        for (ClearPass clearPass : passes) {
            clearPass.execute(fogColor);
        }
    }

    @Override
    public void beginHand() {
        this.renderTargets.copyPreHandDepth();
    }

    @Override
    public void beginTranslucents() {
        this.isBeforeTranslucent = false;
        this.renderTargets.copyPreTranslucentDepth();
        this.beginPass(null);
        this.isRenderingFullScreenPass = true;
        this.deferredRenderer.renderAll();
        RenderSystem.m_69478_();
        this.isRenderingFullScreenPass = false;
    }

    @Override
    public void renderShadows(LevelRendererAccessor levelRenderer, Camera playerCamera) {
        if (this.shadowRenderer != null) {
            this.isRenderingShadow = true;
            this.shadowRenderer.renderShadows(levelRenderer, playerCamera);
            this.beginPass(null);
            this.isRenderingShadow = false;
        }
        this.isRenderingFullScreenPass = true;
        this.prepareRenderer.renderAll();
        this.isRenderingFullScreenPass = false;
    }

    @Override
    public void addDebugText(List<String> messages) {
        messages.add("");
        if (this.shadowRenderer != null) {
            this.shadowRenderer.addDebugText(messages);
        } else {
            messages.add("[Iris] Shadow Maps: not used by shader pack");
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void beginLevelRendering() {
        this.isRenderingFullScreenPass = false;
        this.isRenderingWorld = true;
        this.isBeforeTranslucent = true;
        this.isMainBound = true;
        this.isPostChain = false;
        this.phase = WorldRenderingPhase.NONE;
        this.overridePhase = null;
        HandRenderer.INSTANCE.getBufferSource().resetDrawCalls();
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("beginWorldRender was called but we are not currently rendering a world?");
            return;
        }
        if (this.current != null) {
            throw new IllegalStateException("Called beginLevelRendering but level rendering appears to still be in progress?");
        }
        this.updateNotifier.onNewFrame();
        this.prepareRenderTargets();
        this.setPhase(WorldRenderingPhase.SKY);
        DimensionSpecialEffects.SkyType skyType = Minecraft.m_91087_().f_91073_.m_104583_().m_108883_();
        if (skyType == DimensionSpecialEffects.SkyType.NORMAL) {
            RenderSystem.m_69472_();
            RenderSystem.m_69458_((boolean)false);
            Vector3d fogColor = CapturedRenderingState.INSTANCE.getFogColor();
            RenderSystem.m_157429_((float)((float)fogColor.x), (float)((float)fogColor.y), (float)((float)fogColor.z), (float)1.0f);
            this.horizonRenderer.renderHorizon(CapturedRenderingState.INSTANCE.getGbufferModelView(), CapturedRenderingState.INSTANCE.getGbufferProjection(), GameRenderer.m_172808_());
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69493_();
        }
    }

    @Override
    public void finalizeLevelRendering() {
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("finalizeWorldRendering was called but we are not currently rendering a world?");
            return;
        }
        this.beginPass(null);
        this.isRenderingWorld = false;
        this.phase = WorldRenderingPhase.NONE;
        this.overridePhase = null;
        this.isRenderingFullScreenPass = true;
        this.centerDepthSampler.sampleCenterDepth();
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
        this.isRenderingFullScreenPass = false;
    }

    @Override
    public SodiumTerrainPipeline getSodiumTerrainPipeline() {
        return this.sodiumTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public WorldRenderingPhase getPhase() {
        if (this.overridePhase != null) {
            return this.overridePhase;
        }
        return this.phase;
    }

    public void syncProgram() {
        this.matchPass();
    }

    @Override
    public void beginSodiumTerrainRendering() {
        this.sodiumTerrainRendering = true;
        this.syncProgram();
    }

    @Override
    public void endSodiumTerrainRendering() {
        this.sodiumTerrainRendering = false;
        this.current = null;
        this.syncProgram();
    }

    @Override
    public void setOverridePhase(WorldRenderingPhase phase) {
        this.overridePhase = phase;
        GbufferPrograms.runPhaseChangeNotifier();
    }

    @Override
    public void setPhase(WorldRenderingPhase phase) {
        this.phase = phase;
        GbufferPrograms.runPhaseChangeNotifier();
    }

    public void setInputs(InputAvailability availability) {
        this.inputs = availability;
    }

    @Override
    public void setSpecialCondition(SpecialCondition special) {
        this.special = special;
    }

    @Override
    public RenderTargetStateListener getRenderTargetStateListener() {
        return this;
    }

    private final class Pass {
        @Nullable
        private final Program program;
        private final GlFramebuffer framebufferBeforeTranslucents;
        private final GlFramebuffer framebufferAfterTranslucents;
        @Nullable
        private final AlphaTest alphaTestOverride;
        @Nullable
        private final BlendModeOverride blendModeOverride;
        private final boolean shadowViewport;

        private Pass(Program program, GlFramebuffer framebufferBeforeTranslucents, @Nullable GlFramebuffer framebufferAfterTranslucents, @Nullable AlphaTest alphaTestOverride, BlendModeOverride blendModeOverride, boolean shadowViewport) {
            this.program = program;
            this.framebufferBeforeTranslucents = framebufferBeforeTranslucents;
            this.framebufferAfterTranslucents = framebufferAfterTranslucents;
            this.alphaTestOverride = alphaTestOverride;
            this.blendModeOverride = blendModeOverride;
            this.shadowViewport = shadowViewport;
        }

        public void use() {
            if (DeferredWorldRenderingPipeline.this.isBeforeTranslucent) {
                this.framebufferBeforeTranslucents.bind();
            } else {
                this.framebufferAfterTranslucents.bind();
            }
            if (this.shadowViewport) {
                RenderSystem.m_69949_((int)0, (int)0, (int)DeferredWorldRenderingPipeline.this.shadowMapResolution, (int)DeferredWorldRenderingPipeline.this.shadowMapResolution);
            } else {
                RenderTarget main = Minecraft.m_91087_().m_91385_();
                RenderSystem.m_69949_((int)0, (int)0, (int)main.f_83915_, (int)main.f_83916_);
            }
            if (this.program != null && !DeferredWorldRenderingPipeline.this.sodiumTerrainRendering) {
                this.program.use();
            }
            if (this.alphaTestOverride != null) {
                AlphaTestStorage.overrideAlphaTest(this.alphaTestOverride);
            } else {
                AlphaTestStorage.restoreAlphaTest();
            }
            if (this.blendModeOverride != null) {
                this.blendModeOverride.apply();
            } else {
                BlendModeOverride.restore();
            }
        }

        public void stopUsing() {
            if (this.alphaTestOverride != null) {
                AlphaTestStorage.restoreAlphaTest();
            }
            if (this.blendModeOverride != null) {
                BlendModeOverride.restore();
            }
        }

        @Nullable
        public Program getProgram() {
            return this.program;
        }

        public void destroy() {
            if (this.program != null) {
                this.program.destroy();
            }
        }
    }
}

