/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.util.Size2i;

public final class MathUtil {
    private static final List rectangle2dCroppers = Arrays.asList(MathUtil::cropTop, MathUtil::cropBottom, MathUtil::cropLeft, MathUtil::cropRight);
    private static final Rect2i emptyRect = new Rect2i(0, 0, 0, 0);

    private MathUtil() {
    }

    public static int divideCeil(int n, int n2) {
        return (int)Math.ceil((float)n / (float)n2);
    }

    public static boolean intersects(Collection object, Rect2i rect2i) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!MathUtil.intersects((Rect2i)object.next(), rect2i)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersects(Rect2i rect2i, Rect2i rect2i2) {
        if (rect2i.m_110090_() <= 0 || rect2i.m_110091_() <= 0) {
            return false;
        }
        return rect2i2.m_110085_() + rect2i2.m_110090_() > rect2i.m_110085_() && rect2i2.m_110086_() + rect2i2.m_110091_() > rect2i.m_110086_() && rect2i2.m_110085_() < rect2i.m_110085_() + rect2i.m_110090_() && rect2i2.m_110086_() < rect2i.m_110086_() + rect2i.m_110091_();
    }

    public static Rect2i cropToAvoidIntersection(Collection collection, Rect2i rect2i3, Size2i size2i) {
        return collection.stream().filter(rect2i2 -> MathUtil.intersects(rect2i2, rect2i3)).sorted(Comparator.comparingInt(rect2i -> MathUtil.contentArea(rect2i, size2i))).reduce(rect2i3, (rect2i, rect2i2) -> MathUtil.bestCrop(rect2i, rect2i2, size2i));
    }

    private static Rect2i bestCrop(Rect2i rect2i2, Rect2i rect2i3, Size2i size2i) {
        if (MathUtil.contentArea(rect2i2, size2i) == 0) {
            return rect2i2;
        }
        return rectangle2dCroppers.stream().map(mathUtil$Rectangle2dCropper -> mathUtil$Rectangle2dCropper.crop(rect2i2, rect2i3)).max(Comparator.comparingInt(rect2i -> MathUtil.contentArea(rect2i, size2i))).orElse(emptyRect);
    }

    public static int contentArea(Rect2i rect2i, Size2i size2i) {
        if (rect2i.m_110090_() <= 0 || rect2i.m_110091_() <= 0) {
            return 0;
        }
        return Math.min(rect2i.m_110090_(), size2i.width) * Math.min(rect2i.m_110091_(), size2i.height);
    }

    private static Rect2i cropTop(Rect2i rect2i, Rect2i rect2i2) {
        int n;
        int n2 = rect2i.m_110086_() + rect2i.m_110091_();
        if (n2 < (n = rect2i2.m_110086_() + rect2i2.m_110091_())) {
            return emptyRect;
        }
        return new Rect2i(rect2i.m_110085_(), n, rect2i.m_110090_(), n2 - n);
    }

    private static Rect2i cropBottom(Rect2i rect2i, Rect2i rect2i2) {
        int n = rect2i2.m_110086_() - rect2i.m_110086_();
        if (n < 0) {
            return emptyRect;
        }
        return new Rect2i(rect2i.m_110085_(), rect2i.m_110086_(), rect2i.m_110090_(), n);
    }

    private static Rect2i cropRight(Rect2i rect2i, Rect2i rect2i2) {
        int n = rect2i2.m_110085_() - rect2i.m_110085_();
        if (n < 0) {
            return emptyRect;
        }
        return new Rect2i(rect2i.m_110085_(), rect2i.m_110086_(), n, rect2i.m_110091_());
    }

    private static Rect2i cropLeft(Rect2i rect2i, Rect2i rect2i2) {
        int n;
        int n2 = rect2i.m_110085_() + rect2i.m_110090_();
        if (n2 < (n = rect2i2.m_110085_() + rect2i2.m_110090_())) {
            return emptyRect;
        }
        return new Rect2i(n, rect2i.m_110086_(), n2 - n, rect2i.m_110091_());
    }

    public static boolean contains(Collection object, double d, double d2) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!MathUtil.contains((Rect2i)object.next(), d, d2)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Rect2i rect2i, double d, double d2) {
        return d >= (double)rect2i.m_110085_() && d2 >= (double)rect2i.m_110086_() && d < (double)(rect2i.m_110085_() + rect2i.m_110090_()) && d2 < (double)(rect2i.m_110086_() + rect2i.m_110091_());
    }

    public static Rect2i union(Rect2i rect2i, Rect2i rect2i2) {
        long l = rect2i.m_110090_();
        long l2 = rect2i.m_110091_();
        long l3 = rect2i2.m_110090_();
        long l4 = rect2i2.m_110091_();
        int n = rect2i.m_110085_();
        int n2 = rect2i.m_110086_();
        l += (long)n;
        l2 += (long)n2;
        int n3 = rect2i2.m_110085_();
        int n4 = rect2i2.m_110086_();
        l3 += (long)n3;
        l4 += (long)n4;
        if (n > n3) {
            n = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        if (l < l3) {
            l = l3;
        }
        if (l2 < l4) {
            l2 = l4;
        }
        l -= (long)n;
        l2 -= (long)n2;
        l = Math.min(l, Integer.MAX_VALUE);
        l2 = Math.min(l2, Integer.MAX_VALUE);
        return new Rect2i(n, n2, (int)l, (int)l2);
    }

    public static Rect2i centerTextArea(Rect2i rect2i, Font font, String string) {
        int n = font.m_92895_(string);
        Objects.requireNonNull(font);
        return MathUtil.centerArea(rect2i, n, 9);
    }

    public static Rect2i centerTextArea(Rect2i rect2i, Font font, FormattedText formattedText) {
        int n = font.m_92852_(formattedText);
        Objects.requireNonNull(font);
        return MathUtil.centerArea(rect2i, n, 9);
    }

    public static Rect2i centerArea(Rect2i rect2i, int n, int n2) {
        return new Rect2i(rect2i.m_110085_() + Math.round((float)(rect2i.m_110090_() - n) / 2.0f), rect2i.m_110086_() + Math.round((float)(rect2i.m_110091_() - n2) / 2.0f), n, n2);
    }

    public static double distance(Vec2 vec2, Vec2 vec22) {
        double d = vec2.f_82470_ - vec22.f_82470_;
        double d2 = vec2.f_82471_ - vec22.f_82471_;
        double d3 = d;
        double d4 = d2;
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    public static Tuple splitY(Rect2i rect2i, int n) {
        Rect2i rect2i2 = new Rect2i(rect2i.m_110085_(), rect2i.m_110086_(), rect2i.m_110090_(), n);
        rect2i = new Rect2i(rect2i.m_110085_(), rect2i.m_110086_() + n, rect2i.m_110090_(), rect2i.m_110091_() - n);
        return new Tuple((Object)rect2i2, (Object)rect2i);
    }

    public static Tuple splitYBottom(Rect2i rect2i, int n) {
        Rect2i rect2i2 = rect2i;
        return MathUtil.splitY(rect2i2, rect2i2.m_110091_() - n);
    }

    public static Tuple splitX(Rect2i rect2i, int n) {
        Rect2i rect2i2 = new Rect2i(rect2i.m_110085_(), rect2i.m_110086_(), n, rect2i.m_110091_());
        rect2i = new Rect2i(rect2i.m_110085_() + n, rect2i.m_110086_(), rect2i.m_110090_() - n, rect2i.m_110091_());
        return new Tuple((Object)rect2i2, (Object)rect2i);
    }

    public static Tuple splitXRight(Rect2i rect2i, int n) {
        Rect2i rect2i2 = rect2i;
        return MathUtil.splitX(rect2i2, rect2i2.m_110090_() - n);
    }

    public static boolean equalRects(Collection object, Collection collection) {
        if (object.size() != collection.size()) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Rect2i rect2i = (Rect2i)object.next();
            if (MathUtil.containsRect(collection, rect2i)) continue;
            return false;
        }
        return true;
    }

    public static Rect2i copyRect(Rect2i rect2i) {
        return new Rect2i(rect2i.m_110085_(), rect2i.m_110086_(), rect2i.m_110090_(), rect2i.m_110091_());
    }

    private static boolean containsRect(Collection object, Rect2i rect2i) {
        object = object.iterator();
        while (object.hasNext()) {
            Rect2i rect2i2 = (Rect2i)object.next();
            if (rect2i.m_110085_() != rect2i2.m_110085_() || rect2i.m_110086_() != rect2i2.m_110086_() || rect2i.m_110090_() != rect2i2.m_110090_() || rect2i.m_110091_() != rect2i2.m_110091_()) continue;
            return true;
        }
        return false;
    }
}

