/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator.entity;

import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.blueprint.core.endimator.Endimation;
import com.teamabnormals.blueprint.core.endimator.Endimator;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import java.util.HashMap;
import net.minecraft.client.model.EntityModel;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class EndimatorEntityModel<E extends Entity>
extends EntityModel<E> {
    protected Endimator endimator = new Endimator(new HashMap<String, Endimator.PosedPart>());
    protected E entity;

    public void animateModel(E endimatedEntity, float partialTicks) {
        PlayableEndimation playingEndimation = ((Endimatable)endimatedEntity).getPlayingEndimation();
        Endimation endimation = playingEndimation.asEndimation();
        if (endimation != null) {
            float length;
            float time = ((float)((Endimatable)endimatedEntity).getAnimationTick() + partialTicks) * 0.05f;
            if (time > (length = endimation.getLength())) {
                time = length;
            }
            this.endimator.apply(endimation, time, Endimator.ResetMode.ALL);
            ((Endimatable)endimatedEntity).getEffectHandler().update(endimation, time);
        }
    }

    public void m_6973_(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.entity = entity;
        this.animateModel(entity, ClientInfo.getPartialTicks());
    }
}

