/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public final class BoatRegistry {
    private static final Map<String, BoatData> BOATS = (Map)Util.m_137469_((Object)Maps.newHashMap(), entries -> entries.put("minecraft:oak", new BoatData(() -> Items.f_42453_, () -> Blocks.f_50705_, "minecraft:oak")));

    public static synchronized void registerBoat(String boatName, Supplier<Item> boat, Supplier<Block> plank) {
        BOATS.put(boatName, new BoatData(boat, plank, boatName));
    }

    @Nullable
    public static BoatData getDataForBoat(String boatName) {
        return BOATS.get(boatName);
    }

    public static String getNameForData(BoatData data) {
        for (Map.Entry<String, BoatData> entries : BOATS.entrySet()) {
            if (!entries.getValue().equals(data)) continue;
            return entries.getKey();
        }
        return BoatRegistry.getBaseBoatName();
    }

    public static String getBaseBoatName() {
        return BOATS.size() > 1 ? (String)BOATS.keySet().toArray()[1] : "minecraft:oak";
    }

    public static class BoatData {
        private final Supplier<Item> boat;
        private final Supplier<Block> plank;
        private final ResourceLocation texture;

        public BoatData(Supplier<Item> boat, Supplier<Block> plank, String texture) {
            this.boat = boat;
            this.plank = plank;
            this.texture = this.processTexture(texture);
        }

        public Item getBoatItem() {
            return this.boat.get();
        }

        public Item getPlankItem() {
            return this.plank.get().m_5456_();
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        private ResourceLocation processTexture(String texture) {
            String modId = this.findModId(texture);
            String wood = this.findWood(texture);
            return new ResourceLocation(modId, "textures/entity/boat/" + wood + ".png");
        }

        private String findModId(String parentString) {
            StringBuilder builder = new StringBuilder();
            for (char parentChars : parentString.toCharArray()) {
                if (parentChars == ':') break;
                builder.append(parentChars);
            }
            return builder.toString();
        }

        private String findWood(String parentString) {
            StringBuilder builder = new StringBuilder();
            boolean start = false;
            for (char parentChars : parentString.toCharArray()) {
                if (start) {
                    builder.append(parentChars);
                }
                if (parentChars != ':') continue;
                start = true;
            }
            return builder.toString();
        }
    }
}

