/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraftforge.common.IPlantable;

public final class TreeUtil {
    public static void placeLogAt(LevelWriter level, BlockPos pos, Random rand, TreeConfiguration config) {
        TreeUtil.setForcedState(level, pos, config.f_68185_.m_7112_(rand, pos));
    }

    public static void placeDirectionalLogAt(LevelWriter level, BlockPos pos, Direction direction, Random rand, TreeConfiguration config) {
        TreeUtil.setForcedState(level, pos, (BlockState)config.f_68185_.m_7112_(rand, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()));
    }

    public static boolean isInTag(LevelSimulatedReader level, BlockPos pos, TagKey<Block> tag) {
        return level.m_7433_(pos, block -> block.m_204336_(tag));
    }

    public static void placeLeafAt(LevelSimulatedRW level, BlockPos pos, Random rand, TreeConfiguration config) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos)) {
            TreeUtil.setForcedState((LevelWriter)level, pos, config.f_161213_.m_7112_(rand, pos));
        }
    }

    public static void setForcedState(LevelWriter level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, state, 19);
    }

    public static boolean isLog(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, state -> state.m_204336_(BlockTags.f_13106_));
    }

    public static boolean isLeaves(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, state -> state.m_204336_(BlockTags.f_13035_));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13035_));
    }

    public static void setDirtAt(LevelAccessor level, BlockPos pos) {
        Block block = level.m_8055_(pos).m_60734_();
        if (block == Blocks.f_50440_ || block == Blocks.f_50093_) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 19);
        }
    }

    public static boolean isValidGround(LevelAccessor level, BlockPos pos, SaplingBlock sapling) {
        return level.m_8055_(pos).canSustainPlant((BlockGetter)level, pos, Direction.UP, (IPlantable)sapling);
    }

    public static void updateLeaves(LevelAccessor level, Set<BlockPos> logPositions) {
        ArrayList list = Lists.newArrayList();
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (BlockPos pos : Lists.newArrayList(logPositions)) {
            for (Direction direction : Direction.values()) {
                BlockState state;
                mutablePos.m_122159_((Vec3i)pos, direction);
                if (logPositions.contains(mutablePos) || !(state = level.m_8055_((BlockPos)mutablePos)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(mutablePos.m_7949_());
                TreeUtil.setForcedState((LevelWriter)level, (BlockPos)mutablePos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos pos : set) {
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState state;
                    mutablePos.m_122159_((Vec3i)pos, direction1);
                    if (set.contains(mutablePos) || set1.contains(mutablePos) || !(state = level.m_8055_((BlockPos)mutablePos)).m_61138_((Property)BlockStateProperties.f_61414_) || (k = ((Integer)state.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= l + 1) continue;
                    TreeUtil.setForcedState((LevelWriter)level, (BlockPos)mutablePos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(l + 1)));
                    set1.add(mutablePos.m_7949_());
                }
            }
        }
    }
}

