/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.idas.world.structures;

import com.craisinlord.idas.utils.GeneralUtils;
import com.craisinlord.idas.world.structures.GenericJigsawStructure;
import com.craisinlord.idas.world.structures.configs.IDASGenericNetherConfig;
import com.craisinlord.idas.world.structures.pieces.PieceLimitedJigsawManager;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class GenericNetherJigsawStructure<C extends IDASGenericNetherConfig>
extends GenericJigsawStructure<C> {
    public GenericNetherJigsawStructure(Codec<C> codec) {
        super(codec, GenericJigsawStructure::isGenericFeatureChunk, GenericNetherJigsawStructure::generateNetherPieces);
    }

    public static <CC extends IDASGenericNetherConfig> Optional<PieceGenerator<CC>> generateNetherPieces(PieceGeneratorSupplier.Context<CC> context) {
        IDASGenericNetherConfig config = (IDASGenericNetherConfig)context.f_197356_();
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), config.setFixedYSpawn, context.f_197355_().m_45605_());
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.f_197360_()), blockpos, !config.doNotUseHeightmap, !config.doNotUseHeightmap, Integer.MAX_VALUE, Integer.MIN_VALUE, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
            BlockPos placementPos = config.highestLandSearch ? GeneralUtils.getHighestLand(context.f_197352_(), structurePiecesBuilder.m_192798_(), context.f_197357_(), !config.cannotSpawnInLiquid) : GeneralUtils.getLowestLand(context.f_197352_(), structurePiecesBuilder.m_192798_(), context.f_197357_(), !config.cannotSpawnInLiquid);
            if (placementPos.m_123342_() >= GeneralUtils.getMaxTerrainLimit(context.f_197352_()) || placementPos.m_123342_() <= context.f_197352_().m_6337_() + 1) {
                int yDiff = context.f_197352_().m_6337_() + config.ledgeSpotOffset - ((PoolElementStructurePiece)pieces.get(0)).m_73547_().m_162396_();
                pieces.forEach(piece -> piece.m_6324_(0, yDiff, 0));
            } else {
                int yDiff = placementPos.m_123342_() + config.ledgeSpotOffset - ((PoolElementStructurePiece)pieces.get(0)).m_73547_().m_162396_();
                pieces.forEach(piece -> piece.m_6324_(0, yDiff, 0));
            }
            pieces.forEach(piece -> piece.m_6324_(0, config.centerYOffset, 0));
        });
    }
}

