/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.idas.world.structures;

import com.craisinlord.idas.utils.GeneralUtils;
import com.craisinlord.idas.world.structures.AbstractBaseStructure;
import com.craisinlord.idas.world.structures.configs.IDASOverLavaNetherConfig;
import com.craisinlord.idas.world.structures.pieces.PieceLimitedJigsawManager;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class OverLavaNetherStructure<C extends IDASOverLavaNetherConfig>
extends AbstractBaseStructure<C> {
    public OverLavaNetherStructure(Codec<C> codec) {
        super(codec, OverLavaNetherStructure::isOverLavaNetherFeatureChunk, OverLavaNetherStructure::generateOverLavaNetherPieces);
    }

    protected static <CC extends IDASOverLavaNetherConfig> boolean isOverLavaNetherFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        ChunkPos chunkPos = context.f_197355_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), context.f_197352_().m_6337_() + 1, chunkPos.m_45605_());
        IDASOverLavaNetherConfig config = (IDASOverLavaNetherConfig)context.f_197356_();
        int checkRadius = 16;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int xOffset = -checkRadius; xOffset <= checkRadius; xOffset += 8) {
            for (int zOffset = -checkRadius; zOffset <= checkRadius; zOffset += 8) {
                NoiseColumn blockView = context.f_197352_().m_141914_(xOffset + blockPos.m_123341_(), zOffset + blockPos.m_123343_(), context.f_197357_());
                for (int yOffset = 0; yOffset <= 30; yOffset += 5) {
                    mutable.m_122190_((Vec3i)blockPos).m_122184_(xOffset, yOffset, zOffset);
                    if (blockView.m_183556_(mutable.m_123342_()).m_60795_()) continue;
                    return false;
                }
            }
        }
        for (ResourceKey<StructureSet> structureSetToAvoid : config.structureSetToAvoid) {
            if (!context.f_197352_().m_212265_(structureSetToAvoid, context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_, config.structureAvoidRadius)) continue;
            return false;
        }
        return true;
    }

    public static <CC extends IDASOverLavaNetherConfig> Optional<PieceGenerator<CC>> generateOverLavaNetherPieces(PieceGeneratorSupplier.Context<CC> context) {
        IDASOverLavaNetherConfig config = (IDASOverLavaNetherConfig)context.f_197356_();
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), context.f_197352_().m_6337_() + config.sealevelOffset, context.f_197355_().m_45605_());
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.f_197360_()), blockpos, false, false, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> GeneralUtils.centerAllPieces(blockpos, pieces));
    }
}

