/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.crackable;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.IWPlatformStuff;
import com.ordana.immersive_weathering.WeatheringHelper;
import com.ordana.immersive_weathering.blocks.PatchSpreader;
import com.ordana.immersive_weathering.blocks.Weatherable;
import com.ordana.immersive_weathering.blocks.crackable.CrackSpreader;
import com.ordana.immersive_weathering.reg.ModBlocks;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public interface Crackable
extends Weatherable {
    public static final Supplier<BiMap<Block, Block>> CRACK_LEVEL_INCREASES = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_50222_, (Object)Blocks.f_50224_).put((Object)Blocks.f_50076_, (Object)ModBlocks.CRACKED_BRICKS.get()).put((Object)Blocks.f_50735_, (Object)Blocks.f_50736_).put((Object)Blocks.f_50197_, (Object)Blocks.f_50713_).put((Object)Blocks.f_152589_, (Object)Blocks.f_152594_).put((Object)Blocks.f_152559_, (Object)Blocks.f_152595_).put((Object)Blocks.f_50378_, (Object)ModBlocks.CRACKED_PRISMARINE_BRICKS.get()).put((Object)Blocks.f_50443_, (Object)ModBlocks.CRACKED_END_STONE_BRICKS.get()).put((Object)Blocks.f_50411_, (Object)ModBlocks.CRACKED_STONE_BRICK_SLAB.get()).put((Object)Blocks.f_50410_, (Object)ModBlocks.CRACKED_BRICK_SLAB.get()).put((Object)Blocks.f_50738_, (Object)ModBlocks.CRACKED_POLISHED_BLACKSTONE_BRICK_SLAB.get()).put((Object)Blocks.f_50412_, (Object)ModBlocks.CRACKED_NETHER_BRICK_SLAB.get()).put((Object)Blocks.f_152591_, (Object)ModBlocks.CRACKED_DEEPSLATE_BRICK_SLAB.get()).put((Object)Blocks.f_152561_, (Object)ModBlocks.CRACKED_DEEPSLATE_TILE_SLAB.get()).put((Object)Blocks.f_50384_, (Object)ModBlocks.CRACKED_PRISMARINE_BRICK_SLAB.get()).put((Object)Blocks.f_50648_, (Object)ModBlocks.CRACKED_END_STONE_BRICK_SLAB.get()).put((Object)Blocks.f_50194_, (Object)ModBlocks.CRACKED_STONE_BRICK_STAIRS.get()).put((Object)Blocks.f_50193_, (Object)ModBlocks.CRACKED_BRICK_STAIRS.get()).put((Object)Blocks.f_50739_, (Object)ModBlocks.CRACKED_POLISHED_BLACKSTONE_BRICK_STAIRS.get()).put((Object)Blocks.f_50199_, (Object)ModBlocks.CRACKED_NETHER_BRICK_STAIRS.get()).put((Object)Blocks.f_152590_, (Object)ModBlocks.CRACKED_DEEPSLATE_BRICK_STAIRS.get()).put((Object)Blocks.f_152560_, (Object)ModBlocks.CRACKED_DEEPSLATE_TILE_STAIRS.get()).put((Object)Blocks.f_50381_, (Object)ModBlocks.CRACKED_PRISMARINE_BRICK_STAIRS.get()).put((Object)Blocks.f_50634_, (Object)ModBlocks.CRACKED_END_STONE_BRICK_STAIRS.get()).put((Object)Blocks.f_50609_, (Object)ModBlocks.CRACKED_STONE_BRICK_WALL.get()).put((Object)Blocks.f_50604_, (Object)ModBlocks.CRACKED_BRICK_WALL.get()).put((Object)Blocks.f_50740_, (Object)ModBlocks.CRACKED_POLISHED_BLACKSTONE_BRICK_WALL.get()).put((Object)Blocks.f_50610_, (Object)ModBlocks.CRACKED_NETHER_BRICK_WALL.get()).put((Object)Blocks.f_152592_, (Object)ModBlocks.CRACKED_DEEPSLATE_BRICK_WALL.get()).put((Object)Blocks.f_152562_, (Object)ModBlocks.CRACKED_DEEPSLATE_TILE_WALL.get()).put((Object)ModBlocks.PRISMARINE_BRICK_WALL.get(), (Object)ModBlocks.CRACKED_PRISMARINE_BRICK_WALL.get()).put((Object)Blocks.f_50614_, (Object)ModBlocks.CRACKED_END_STONE_BRICK_WALL.get());
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:vertical_brick_slab", "immersive_weathering:vertical_cracked_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:vertical_stone_brick_slab", "immersive_weathering:vertical_cracked_stone_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:vertical_polished_blackstone_brick_slab", "immersive_weathering:vertical_cracked_polished_blackstone_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:vertical_nether_brick_slab", "immersive_weathering:vertical_cracked_nether_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:vertical_deepslate_brick_slab", "immersive_weathering:vertical_cracked_deepslate_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:vertical_deepslate_tile_slab", "immersive_weathering:vertical_cracked_deepslate_tile_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:vertical_end_stone_brick_slab", "immersive_weathering:vertical_cracked_end_stone_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:vertical_prismarine_brick_slab", "immersive_weathering:vertical_cracked_prismarine_brick_slab");
        IWPlatformStuff.addExtraCrackedBlocks((ImmutableBiMap.Builder<Block, Block>)builder);
        return builder.build();
    });
    public static final Supplier<BiMap<Block, Block>> CRACK_LEVEL_DECREASES = Suppliers.memoize(() -> CRACK_LEVEL_INCREASES.get().inverse());

    public static BlockState getUncrackedCrackBlock(BlockState state) {
        Block block2 = state.m_60734_();
        Block block3 = (Block)CRACK_LEVEL_DECREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (Block)CRACK_LEVEL_DECREASES.get().get((Object)block2);
        }
        return block2.m_152465_(state);
    }

    public static BlockState getCrackedBlock(BlockState state) {
        Block block2 = state.m_60734_();
        Block block3 = (Block)CRACK_LEVEL_INCREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (Block)CRACK_LEVEL_INCREASES.get().get((Object)block2);
        }
        return block2.m_152465_(state);
    }

    public static Optional<Block> getDecreasedCrackBlock(Block block) {
        return Optional.ofNullable((Block)CRACK_LEVEL_DECREASES.get().get((Object)block));
    }

    public static Optional<Block> getIncreasedCrackBlock(Block block) {
        return Optional.ofNullable((Block)CRACK_LEVEL_INCREASES.get().get((Object)block));
    }

    default public Optional<BlockState> getNextCracked(BlockState state) {
        return Crackable.getIncreasedCrackBlock(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    default public Optional<BlockState> getPreviousCracked(BlockState state) {
        return Crackable.getDecreasedCrackBlock(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public CrackSpreader getCrackSpreader();

    @Override
    default public <T extends Enum<?>> Optional<PatchSpreader<T>> getPatchSpreader(Class<T> weatheringClass) {
        if (weatheringClass == CrackLevel.class) {
            return Optional.of(this.getCrackSpreader());
        }
        return Optional.empty();
    }

    public CrackLevel getCrackLevel();

    @Override
    default public boolean shouldWeather(BlockState state, BlockPos pos, Level level) {
        return this.getCrackSpreader().getWantedWeatheringState(false, pos, level);
    }

    public Item getRepairItem(BlockState var1);

    @Override
    default public void tryWeather(BlockState state, ServerLevel serverLevel, BlockPos pos, Random random) {
        if (random.nextFloat() < this.getWeatherChanceSpeed()) {
            BlockState newState;
            Optional<BlockState> opt = Optional.empty();
            if (this.getCrackSpreader().getWantedWeatheringState(true, pos, (Level)serverLevel)) {
                opt = this.getNextCracked(state);
            }
            if ((newState = opt.orElse((BlockState)state.m_61124_(Weatherable.WEATHERABLE, (Comparable)((Object)Weatherable.WeatheringState.FALSE)))) != state) {
                serverLevel.m_7731_(pos, newState, 2);
                if (!newState.m_61138_(Weatherable.WEATHERABLE)) {
                    serverLevel.m_186460_(pos, state.m_60734_(), 1);
                }
            }
        }
    }

    public static enum CrackLevel {
        UNCRACKED,
        CRACKED;

    }
}

