/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.soil;

import com.ordana.immersive_weathering.blocks.Soaked;
import com.ordana.immersive_weathering.blocks.soil.SoilBlock;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModItems;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FluvisolBlock
extends SoilBlock
implements Soaked {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PUDDLE_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public FluvisolBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SOAKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FERTILE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{SOAKED});
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)SOAKED)).booleanValue()) {
            return PUDDLE_SHAPE;
        }
        return SHAPE;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter world, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)SOAKED)).booleanValue()) {
            return PUDDLE_SHAPE;
        }
        return SHAPE;
    }

    @Override
    public boolean canGrow(BlockState state) {
        return (Boolean)state.m_61143_((Property)FERTILE) != false && (Boolean)state.m_61143_((Property)SOAKED) != false;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        BlockState downState = world.m_8055_(pos.m_7495_());
        if (downState.m_60713_(ModBlocks.SILT.get()) || downState.m_60713_(ModBlocks.FLUVISOL.get())) {
            world.m_46597_(pos.m_7495_(), Blocks.f_50493_.m_49966_());
        }
        boolean newState = world.m_46758_(pos.m_7494_());
        if ((Boolean)state.m_61143_((Property)SOAKED) != newState) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)SOAKED, (Comparable)Boolean.valueOf(newState)));
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (((Boolean)state.m_61143_((Property)SOAKED)).booleanValue() && world.f_46443_ && (!(entity instanceof LivingEntity) || entity.m_146900_().m_60713_((Block)this))) {
            boolean bl;
            Random random = world.m_5822_();
            boolean bl2 = bl = entity.f_19790_ != entity.m_20185_() || entity.f_19792_ != entity.m_20189_();
            if (bl && random.nextBoolean()) {
                world.m_6493_((ParticleOptions)ParticleTypes.f_123769_, false, entity.m_20185_() + (double)Mth.m_144924_((Random)random, (float)-0.2f, (float)0.2f), (double)pos.m_123342_() + 1.0, entity.m_20189_() + (double)Mth.m_144924_((Random)random, (float)-0.2f, (float)0.2f), 0.0, 0.25, 0.0);
            }
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42590_ && ((Boolean)state.m_61143_((Property)SOAKED)).booleanValue() && CommonConfigs.MUDDY_WATER_ENABLED.get().booleanValue()) {
            level.m_5594_(player, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123769_, (UniformInt)UniformInt.m_146622_((int)3, (int)5));
            if (player instanceof ServerPlayer) {
                ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)ModItems.POND_WATER.get().m_7968_());
                player.m_21008_(hand, itemStack2);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)SOAKED, (Comparable)Boolean.FALSE));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }
}

