/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.position_tests;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.position_tests.PositionRuleTest;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class EntityTest
implements PositionRuleTest {
    public static final String NAME = "entity_test";
    public static final Codec<EntityTest> CODEC = RecordCodecBuilder.create(i -> i.group((App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122903_).fieldOf("targets").forGetter(EntityTest::getTargets), (App)IntProvider.m_146545_((int)0, (int)100).fieldOf("count").forGetter(EntityTest::getIntProvider), (App)Codec.intRange((int)0, (int)64).fieldOf("radius").forGetter(EntityTest::getSize), (App)Codec.BOOL.optionalFieldOf("less_than").forGetter(EntityTest::isLessThan), (App)Direction.f_175356_.optionalFieldOf("look_direction").forGetter(EntityTest::getDirection), (App)Codec.INT.optionalFieldOf("offset").forGetter(EntityTest::getOffset)).apply((Applicative)i, EntityTest::new));
    static final PositionRuleTest.Type<EntityTest> TYPE = new PositionRuleTest.Type<EntityTest>(CODEC, "entity_test");
    private final HolderSet<EntityType<?>> targets;
    private final IntProvider intProvider;
    private final boolean lessThan;
    private final int size;
    private final int offset;
    @Nullable
    private final Direction direction;

    private EntityTest(HolderSet<EntityType<?>> targets, IntProvider intProvider, int size, Optional<Boolean> lessThan, Optional<Direction> direction, Optional<Integer> offset) {
        this.targets = targets;
        this.intProvider = intProvider;
        this.size = size;
        this.lessThan = lessThan.orElse(false);
        this.direction = direction.orElse(null);
        this.offset = offset.orElse(0);
    }

    public IntProvider getIntProvider() {
        return this.intProvider;
    }

    public HolderSet<EntityType<?>> getTargets() {
        return this.targets;
    }

    public int getSize() {
        return this.size;
    }

    public Optional<Boolean> isLessThan() {
        return Optional.of(this.lessThan);
    }

    public Optional<Integer> getOffset() {
        return Optional.of(this.offset);
    }

    public Optional<Direction> getDirection() {
        return Optional.ofNullable(this.direction);
    }

    @Override
    public boolean test(Holder<Biome> biome, BlockPos pos, Level level) {
        AABB aabb = new AABB(pos).m_82400_((double)this.size);
        if (this.direction != null && this.offset != 0) {
            aabb = aabb.m_82386_((double)(this.direction.m_122429_() * this.offset), (double)(this.direction.m_122430_() * this.offset), (double)(this.direction.m_122431_() * this.offset));
        }
        List list = level.m_6249_((Entity)null, aabb, this::isEntityValid);
        int sampled = this.intProvider.m_142270_(level.f_46441_);
        if (this.lessThan) {
            return list.size() <= sampled;
        }
        return list.size() >= sampled;
    }

    public boolean isEntityValid(Entity e) {
        return this.targets.m_203333_((Holder)e.m_6095_().m_204041_());
    }

    @Override
    public PositionRuleTest.Type<?> getType() {
        return TYPE;
    }
}

