/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.items;

import com.ordana.immersive_weathering.reg.ModParticles;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FlowerCrownItem
extends ArmorItem {
    private static final Map<String, SpecialType> SUPPORTERS_LIST = new HashMap<String, SpecialType>(){
        {
            this.put("ordana", new SpecialType("textures/models/armor/bee.png", 0.1f, ModParticles.FLOWER_BEE));
            this.put("bee", new SpecialType("textures/models/armor/bee.png", 0.1f, ModParticles.FLOWER_BEE));
            this.put("mehvahdjukaar", new SpecialType("textures/models/armor/jar.png", 0.11f, ModParticles.FLOWER_JAR));
            this.put("jar", new SpecialType("textures/models/armor/jar.png", 0.11f, ModParticles.FLOWER_JAR));
            this.put("asexual", new SpecialType("textures/models/armor/ace.png", 0.2f, ModParticles.FLOWER_ACE));
            this.put("ace", new SpecialType("textures/models/armor/ace.png", 0.2f, ModParticles.FLOWER_ACE));
            this.put("aromantic", new SpecialType("textures/models/armor/aro.png", 0.201f, ModParticles.FLOWER_ARO));
            this.put("aro", new SpecialType("textures/models/armor/aro.png", 0.201f, ModParticles.FLOWER_ARO));
            this.put("bisexual", new SpecialType("textures/models/armor/bi.png", 0.202f, ModParticles.FLOWER_BI));
            this.put("bi", new SpecialType("textures/models/armor/bi.png", 0.202f, ModParticles.FLOWER_BI));
            this.put("non-binary", new SpecialType("textures/models/armor/enby.png", 0.203f, ModParticles.FLOWER_ENBY));
            this.put("nb", new SpecialType("textures/models/armor/enby.png", 0.203f, ModParticles.FLOWER_ENBY));
            this.put("enby", new SpecialType("textures/models/armor/enby.png", 0.203f, ModParticles.FLOWER_ENBY));
            this.put("gay", new SpecialType("textures/models/armor/gay.png", 0.204f, ModParticles.FLOWER_GAY));
            this.put("mlm", new SpecialType("textures/models/armor/gay.png", 0.204f, ModParticles.FLOWER_GAY));
            this.put("lesbian", new SpecialType("textures/models/armor/lesbian.png", 0.205f, ModParticles.FLOWER_LESBIAN));
            this.put("wlw", new SpecialType("textures/models/armor/lesbian.png", 0.205f, ModParticles.FLOWER_LESBIAN));
            this.put("rainbow", new SpecialType("textures/models/armor/rainbow.png", 0.206f, ModParticles.FLOWER_RAINBOW));
            this.put("pride", new SpecialType("textures/models/armor/rainbow.png", 0.206f, ModParticles.FLOWER_RAINBOW));
            this.put("trans", new SpecialType("textures/models/armor/trans.png", 0.207f, ModParticles.FLOWER_TRANS));
            this.put("transgender", new SpecialType("textures/models/armor/trans.png", 0.207f, ModParticles.FLOWER_TRANS));
            this.put("pan", new SpecialType("textures/models/armor/pan.png", 0.208f, ModParticles.FLOWER_PAN));
            this.put("pansexual", new SpecialType("textures/models/armor/pan.png", 0.208f, ModParticles.FLOWER_PAN));
            this.put("intersex", new SpecialType("textures/models/armor/intersex.png", 0.209f, ModParticles.FLOWER_INTERSEX));
            this.put("genderqueer", new SpecialType("textures/models/armor/genderqueer.png", 0.21f, ModParticles.FLOWER_GENDERQUEER));
            this.put("genderfluid", new SpecialType("textures/models/armor/fluid.png", 0.211f, ModParticles.FLOWER_FLUID));
            this.put("fluid", new SpecialType("textures/models/armor/fluid.png", 0.211f, ModParticles.FLOWER_FLUID));
            this.put("flax", new SpecialType("textures/models/armor/flax.png", 0.3f, ModParticles.FLOWER_FLAX));
        }
    };

    public FlowerCrownItem(ArmorMaterial material, EquipmentSlot slot, Item.Properties settings) {
        super(material, slot, settings);
    }

    @PlatformOnly(value={"forge"})
    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (level.f_46443_) {
            FlowerCrownItem.spawnParticles(stack, level, (Entity)player, level);
        }
    }

    private static void spawnParticles(ItemStack stack, Level level, Entity entity, Level serverLevel) {
        if ((double)level.f_46441_.nextFloat() < 0.05) {
            Vec3 v = entity.m_20252_(1.0f).m_82490_(entity.m_6069_() ? 1.8 : (double)-0.15f);
            serverLevel.m_7106_((ParticleOptions)FlowerCrownItem.getParticle(stack), v.f_82479_ + entity.m_20208_(0.675), v.f_82480_ + entity.m_20186_() + (double)entity.m_20192_() + 0.15, v.f_82481_ + entity.m_20262_(0.675), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    @PlatformOnly(value={"forge"})
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return FlowerCrownItem.getModelTexture(stack);
    }

    @Nullable
    public static String getModelTexture(ItemStack stack) {
        String name;
        SpecialType m;
        if (stack.m_41788_() && (m = SUPPORTERS_LIST.get((name = stack.m_41786_().m_6111_()).toLowerCase(Locale.ROOT))) != null) {
            return m.textureLocation;
        }
        return null;
    }

    public static SimpleParticleType getParticle(ItemStack stack) {
        SpecialType type = FlowerCrownItem.getSpecialType(stack);
        if (type != null) {
            return type.particle.get();
        }
        return ModParticles.AZALEA_FLOWER.get();
    }

    public static float getItemTextureIndex(ItemStack stack) {
        SpecialType type = FlowerCrownItem.getSpecialType(stack);
        if (type != null) {
            return type.itemModelIndex;
        }
        return 0.0f;
    }

    @Nullable
    public static SpecialType getSpecialType(ItemStack stack) {
        if (stack.m_41788_()) {
            String name = stack.m_41786_().m_6111_();
            return SUPPORTERS_LIST.get(name.toLowerCase(Locale.ROOT));
        }
        return null;
    }

    public record SpecialType(String textureLocation, float itemModelIndex, Supplier<SimpleParticleType> particle) {
    }
}

