/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.supernatural.init;

import net.mcreator.supernatural.entity.GhostEctoEntity;
import net.mcreator.supernatural.entity.GhostSpookyEntity;
import net.mcreator.supernatural.entity.MerAmethystEntity;
import net.mcreator.supernatural.entity.MerDiamondEntity;
import net.mcreator.supernatural.entity.MerEmeraldEntity;
import net.mcreator.supernatural.entity.PossessedArmorEntity;
import net.mcreator.supernatural.entity.VampireEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SupernaturalModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"supernatural");
    public static final RegistryObject<EntityType<VampireEntity>> VAMPIRE = SupernaturalModEntities.register("vampire", EntityType.Builder.m_20704_(VampireEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(VampireEntity::new).m_20699_(0.6f, 1.95f));
    public static final RegistryObject<EntityType<PossessedArmorEntity>> POSSESSED_ARMOR = SupernaturalModEntities.register("possessed_armor", EntityType.Builder.m_20704_(PossessedArmorEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(PossessedArmorEntity::new).m_20699_(0.6f, 1.95f));
    public static final RegistryObject<EntityType<GhostEctoEntity>> GHOST_ECTO = SupernaturalModEntities.register("ghost_ecto", EntityType.Builder.m_20704_(GhostEctoEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(GhostEctoEntity::new).m_20719_().m_20699_(0.5f, 1.95f));
    public static final RegistryObject<EntityType<GhostSpookyEntity>> GHOST_SPOOKY = SupernaturalModEntities.register("ghost_spooky", EntityType.Builder.m_20704_(GhostSpookyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(GhostSpookyEntity::new).m_20719_().m_20699_(0.6f, 1.95f));
    public static final RegistryObject<EntityType<MerAmethystEntity>> MER_AMETHYST = SupernaturalModEntities.register("mer_amethyst", EntityType.Builder.m_20704_(MerAmethystEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MerAmethystEntity::new).m_20699_(0.6f, 1.95f));
    public static final RegistryObject<EntityType<MerEmeraldEntity>> MER_EMERALD = SupernaturalModEntities.register("mer_emerald", EntityType.Builder.m_20704_(MerEmeraldEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MerEmeraldEntity::new).m_20699_(0.6f, 1.95f));
    public static final RegistryObject<EntityType<MerDiamondEntity>> MER_DIAMOND = SupernaturalModEntities.register("mer_diamond", EntityType.Builder.m_20704_(MerDiamondEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MerDiamondEntity::new).m_20699_(0.6f, 1.95f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            VampireEntity.init();
            PossessedArmorEntity.init();
            GhostEctoEntity.init();
            GhostSpookyEntity.init();
            MerAmethystEntity.init();
            MerEmeraldEntity.init();
            MerDiamondEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)VAMPIRE.get(), VampireEntity.createAttributes().m_22265_());
        event.put((EntityType)POSSESSED_ARMOR.get(), PossessedArmorEntity.createAttributes().m_22265_());
        event.put((EntityType)GHOST_ECTO.get(), GhostEctoEntity.createAttributes().m_22265_());
        event.put((EntityType)GHOST_SPOOKY.get(), GhostSpookyEntity.createAttributes().m_22265_());
        event.put((EntityType)MER_AMETHYST.get(), MerAmethystEntity.createAttributes().m_22265_());
        event.put((EntityType)MER_EMERALD.get(), MerEmeraldEntity.createAttributes().m_22265_());
        event.put((EntityType)MER_DIAMOND.get(), MerDiamondEntity.createAttributes().m_22265_());
    }
}

