/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.effects;

import dynamiclabs.immersivefx.environs.effects.BlockEffectType;
import dynamiclabs.immersivefx.environs.handlers.scripts.ConditionEvaluator;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BlockEffect {
    private int chance;
    protected String conditions = "";

    public BlockEffect() {
        this(100);
    }

    protected BlockEffect(int chance) {
        this.chance = chance;
    }

    @Nonnull
    public abstract BlockEffectType getEffectType();

    public void setConditions(@Nullable String conditions) {
        this.conditions = conditions == null ? "" : conditions.intern();
    }

    @Nonnull
    public String getConditions() {
        return this.conditions;
    }

    public void setChance(int chance) {
        this.chance = chance;
    }

    public int getChance() {
        return this.chance;
    }

    public boolean alwaysExecute() {
        return this.chance == 0;
    }

    public boolean canTrigger(@Nonnull BlockGetter provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        if (!this.alwaysExecute() && random.nextInt(this.getChance()) != 0) {
            return false;
        }
        return ConditionEvaluator.INSTANCE.check(this.getConditions());
    }

    public abstract void doEffect(@Nonnull BlockGetter var1, @Nonnull BlockState var2, @Nonnull BlockPos var3, @Nonnull Random var4);

    @Nonnull
    public String toString() {
        return "type: " + this.getEffectType().getName() + " conditions: [" + this.getConditions() + "]; chance:" + this.getChance() + " " + this.getClass().getSimpleName();
    }
}

