/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.effects.emitters;

import dynamiclabs.immersivefx.environs.config.Config;
import dynamiclabs.immersivefx.environs.effects.WaterfallSplashEffect;
import dynamiclabs.immersivefx.environs.effects.emitters.Jet;
import dynamiclabs.immersivefx.environs.effects.particles.Collections;
import dynamiclabs.immersivefx.environs.handlers.CommonState;
import dynamiclabs.immersivefx.environs.library.Constants;
import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.WorldUtils;
import dynamiclabs.immersivefx.lib.math.MathStuff;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.Library;
import dynamiclabs.immersivefx.sndctrl.audio.AudioEngine;
import dynamiclabs.immersivefx.sndctrl.audio.LoopingSoundInstance;
import dynamiclabs.immersivefx.sndctrl.audio.SoundUtils;
import java.util.Arrays;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WaterSplashJet
extends Jet {
    private static final ResourceLocation[] waterfallAcoustics = new ResourceLocation[11];
    protected LoopingSoundInstance sound;
    protected int particleLimit;
    protected final double deltaY;

    public WaterSplashJet(int strength, BlockGetter world, BlockPos loc, double dY) {
        super(0, strength, world, (double)loc.m_123341_() + 0.5, (double)loc.m_123342_() + 0.5, (double)loc.m_123343_() + 0.5, 4);
        this.deltaY = (double)loc.m_123342_() + dY;
        this.setSpawnCount((int)((float)strength * 2.5f));
    }

    public void setSpawnCount(int limit) {
        this.particleLimit = MathStuff.clamp(limit, 5, 20);
    }

    public int getSpawnCount() {
        ParticleStatus state = GameUtils.getGameSettings().f_92073_;
        switch (state) {
            case MINIMAL: {
                return 0;
            }
            case ALL: {
                return this.particleLimit;
            }
        }
        return this.particleLimit / 2;
    }

    @Override
    public boolean shouldDie() {
        return this.particleAge % 10 == 0 && !WaterfallSplashEffect.isValidSpawnBlock(this.world, this.position);
    }

    @Override
    protected void soundUpdate() {
        if (!this.isAlive()) {
            return;
        }
        if (this.jetStrength <= (Integer)Config.CLIENT.effects.waterfallCutoff.get()) {
            return;
        }
        if (this.sound == null) {
            int idx = MathStuff.clamp(this.jetStrength, 0, waterfallAcoustics.length - 1);
            IAcoustic acoustic = Library.resolve(waterfallAcoustics[idx]);
            this.sound = new LoopingSoundInstance(acoustic.getFactory().createSoundAt(this.position), Constants.WATERFALL);
        }
        boolean inRange = SoundUtils.inRange(CommonState.getPlayerEyePosition(), this.sound, 4);
        boolean isActive = this.sound.getState().isActive();
        if (inRange && !isActive) {
            AudioEngine.play(this.sound);
        } else if (!inRange && isActive) {
            AudioEngine.stop(this.sound);
        }
    }

    @Override
    protected void cleanUp() {
        if (this.sound != null) {
            AudioEngine.stop(this.sound);
            this.sound = null;
        }
        super.cleanUp();
    }

    @Override
    protected void spawnJetParticle() {
        if (Collections.canFitWaterSpray()) {
            int splashCount = this.getSpawnCount();
            int j = 0;
            while ((float)j < (float)splashCount) {
                double zOffset;
                double xOffset = RANDOM.nextFloat() * 2.0f - 1.0f;
                if (!WorldUtils.isBlockSolid(this.world, new BlockPos(this.posX + xOffset, this.deltaY, this.posZ + (zOffset = (double)(RANDOM.nextFloat() * 2.0f - 1.0f))))) {
                    int motionStr = this.jetStrength + 3;
                    double motionX = xOffset * ((double)motionStr / 20.0);
                    double motionZ = zOffset * ((double)motionStr / 20.0);
                    double motionY = 0.1 + (double)(RANDOM.nextFloat() * (float)motionStr) / 20.0;
                    boolean added = Collections.addWaterSpray(this.world, this.posX + xOffset, this.deltaY, this.posZ + zOffset, motionX, motionY, motionZ);
                    if (!added) break;
                }
                ++j;
            }
        }
    }

    static {
        ResourceLocation defaultAcoustic = new ResourceLocation("environs", "waterfall/0");
        Arrays.fill(waterfallAcoustics, defaultAcoustic);
        WaterSplashJet.waterfallAcoustics[2] = WaterSplashJet.waterfallAcoustics[3] = new ResourceLocation("environs", "waterfall/1");
        WaterSplashJet.waterfallAcoustics[4] = new ResourceLocation("environs", "waterfall/2");
        WaterSplashJet.waterfallAcoustics[5] = WaterSplashJet.waterfallAcoustics[6] = new ResourceLocation("environs", "waterfall/3");
        WaterSplashJet.waterfallAcoustics[7] = WaterSplashJet.waterfallAcoustics[8] = new ResourceLocation("environs", "waterfall/4");
        WaterSplashJet.waterfallAcoustics[9] = WaterSplashJet.waterfallAcoustics[10] = new ResourceLocation("environs", "waterfall/5");
    }
}

