/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.fog;

import dynamiclabs.immersivefx.environs.Environs;
import dynamiclabs.immersivefx.environs.config.Config;
import dynamiclabs.immersivefx.environs.fog.FogResult;
import dynamiclabs.immersivefx.environs.fog.IFogRangeCalculator;
import dynamiclabs.immersivefx.lib.collections.ObjectArray;
import dynamiclabs.immersivefx.lib.logging.IModLog;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;

@OnlyIn(value=Dist.CLIENT)
public class HolisticFogRangeCalculator
implements IFogRangeCalculator {
    private static final IModLog LOGGER = Environs.LOGGER.createChild(HolisticFogRangeCalculator.class);
    protected final ObjectArray<IFogRangeCalculator> calculators = new ObjectArray(8);
    protected final FogResult cached = new FogResult();

    public void add(@Nonnull IFogRangeCalculator calc) {
        this.calculators.add(calc);
    }

    @Override
    @Nonnull
    public String getName() {
        return "HolisticFogRangeCalculator";
    }

    @Override
    public boolean enabled() {
        return (Boolean)Config.CLIENT.fog.enableFog.get();
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        this.cached.set(event);
        float start = this.cached.getStart();
        float end = this.cached.getEnd();
        for (IFogRangeCalculator calc : this.calculators) {
            if (!calc.enabled()) continue;
            FogResult result = calc.calculate(event);
            if (result.getStart() > result.getEnd() || result.getStart() < 0.0f || result.getEnd() < 0.0f) {
                LOGGER.warn("Fog calculator '%s' reporting invalid fog range (start %f, end %f); ignored", calc.getName(), Float.valueOf(result.getStart()), Float.valueOf(result.getEnd()));
                continue;
            }
            start = Math.min(start, result.getStart());
            end = Math.min(end, result.getEnd());
        }
        this.cached.set(start, end);
        return this.cached;
    }

    @Override
    public void tick() {
        this.calculators.forEach(IFogRangeCalculator::tick);
    }

    @Nonnull
    public String toString() {
        return this.cached.toString();
    }
}

