/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.handlers;

import dynamiclabs.immersivefx.environs.config.Config;
import dynamiclabs.immersivefx.environs.handlers.HandlerBase;
import dynamiclabs.immersivefx.environs.scanner.AlwaysOnBlockEffectScanner;
import dynamiclabs.immersivefx.environs.scanner.ClientPlayerLocus;
import dynamiclabs.immersivefx.environs.scanner.RandomBlockEffectScanner;
import dynamiclabs.immersivefx.lib.events.BlockUpdateEvent;
import dynamiclabs.immersivefx.lib.events.DiagnosticEvent;
import dynamiclabs.immersivefx.lib.math.LoggingTimerEMA;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
class AreaBlockEffects
extends HandlerBase {
    protected final LoggingTimerEMA blockChange = new LoggingTimerEMA("Area Block Update");
    protected ClientPlayerLocus locus;
    protected RandomBlockEffectScanner nearEffects;
    protected RandomBlockEffectScanner farEffects;
    protected AlwaysOnBlockEffectScanner alwaysOn;
    protected long nanos;

    public AreaBlockEffects() {
        super("Area Block Effects");
    }

    @Override
    public void process(@Nonnull Player player) {
        this.nearEffects.tick();
        this.farEffects.tick();
        this.alwaysOn.tick();
        this.blockChange.update(this.nanos);
        this.nanos = 0L;
    }

    @Override
    public void onConnect() {
        this.locus = new ClientPlayerLocus();
        this.nearEffects = new RandomBlockEffectScanner(this.locus, 16);
        this.farEffects = new RandomBlockEffectScanner(this.locus, 32);
        this.alwaysOn = new AlwaysOnBlockEffectScanner(this.locus, Config.CLIENT.effects.get_effectRange());
    }

    @Override
    public void onDisconnect() {
        this.locus = null;
        this.nearEffects = null;
        this.farEffects = null;
        this.alwaysOn = null;
    }

    @SubscribeEvent
    public void onDiagnostics(@Nonnull DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            event.addRenderTimer(this.blockChange);
        }
    }

    @SubscribeEvent
    public void onBlockUpdate(@Nonnull BlockUpdateEvent event) {
        long start = System.nanoTime();
        event.getExpandedPositions().forEach(this.alwaysOn::onBlockUpdate);
        this.nanos += System.nanoTime() - start;
    }
}

