/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.handlers;

import com.mojang.blaze3d.systems.RenderSystem;
import dynamiclabs.immersivefx.environs.config.Config;
import dynamiclabs.immersivefx.environs.fog.BedrockFogRangeCalculator;
import dynamiclabs.immersivefx.environs.fog.BiomeFogRangeCalculator;
import dynamiclabs.immersivefx.environs.fog.FogResult;
import dynamiclabs.immersivefx.environs.fog.HazeFogRangeCalculator;
import dynamiclabs.immersivefx.environs.fog.HolisticFogRangeCalculator;
import dynamiclabs.immersivefx.environs.fog.MorningFogRangeCalculator;
import dynamiclabs.immersivefx.environs.fog.WeatherFogRangeCalculator;
import dynamiclabs.immersivefx.environs.handlers.CommonState;
import dynamiclabs.immersivefx.environs.handlers.HandlerBase;
import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.events.DiagnosticEvent;
import dynamiclabs.immersivefx.lib.math.LoggingTimerEMA;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class FogHandler
extends HandlerBase {
    protected final LoggingTimerEMA render = new LoggingTimerEMA("Render Fog");
    protected HolisticFogRangeCalculator fogRange = new HolisticFogRangeCalculator();

    public FogHandler() {
        super("Fog Handler");
    }

    public static boolean doFog() {
        return (Boolean)Config.CLIENT.fog.enableFog.get() != false && CommonState.getDimensionInfo().hasFog();
    }

    @Override
    public void process(@Nonnull Player player) {
        if (FogHandler.doFog()) {
            this.fogRange.tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void fogRenderEvent(EntityViewRenderEvent.RenderFogEvent event) {
        if (event.getMode() == FogRenderer.FogMode.FOG_TERRAIN && FogHandler.doFog()) {
            ProfilerFiller profiler = GameUtils.getMC().m_91307_();
            profiler.m_6180_("Environs Fog Render");
            this.render.begin();
            FogType fluidState = event.getCamera().m_167685_();
            if (fluidState == FogType.NONE) {
                FogResult result = this.fogRange.calculate(event);
                RenderSystem.m_157445_((float)result.getStart());
                RenderSystem.m_157443_((float)result.getEnd());
            }
            this.render.end();
            profiler.m_7238_();
        }
    }

    @SubscribeEvent
    public void diagnostics(DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            if (FogHandler.doFog()) {
                event.getLeft().add("Fog Range: " + this.fogRange.toString());
                event.addRenderTimer(this.render);
            } else {
                event.getLeft().add("FOG: IGNORED");
            }
        }
    }

    @Override
    public void onConnect() {
        this.fogRange = new HolisticFogRangeCalculator();
        this.fogRange.add(new BiomeFogRangeCalculator());
        this.fogRange.add(new HazeFogRangeCalculator());
        this.fogRange.add(new MorningFogRangeCalculator());
        this.fogRange.add(new BedrockFogRangeCalculator());
        this.fogRange.add(new WeatherFogRangeCalculator());
    }
}

