/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.library;

import dynamiclabs.immersivefx.environs.library.IBiome;
import dynamiclabs.immersivefx.lib.biomes.BiomeUtilities;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;

@OnlyIn(value=Dist.CLIENT)
public class BiomeAdapter
implements IBiome {
    protected final Biome biome;
    protected final Set<BiomeDictionary.Type> types;

    public BiomeAdapter(@Nonnull Biome biome) {
        this.biome = biome;
        this.types = BiomeUtilities.getBiomeTypes(this.biome);
    }

    @Override
    public Biome getBiome() {
        return this.biome;
    }

    @Override
    public ResourceLocation getKey() {
        return this.biome.getRegistryName();
    }

    @Override
    public String getName() {
        return BiomeUtilities.getBiomeName(this.biome);
    }

    @Override
    public Set<BiomeDictionary.Type> getTypes() {
        return this.types;
    }

    @Override
    public Biome.Precipitation getPrecipitationType() {
        return this.biome.m_47530_();
    }

    @Override
    public float getFloatTemperature(@Nonnull BlockPos pos) {
        return this.biome.m_47505_(pos);
    }

    @Override
    public float getTemperature() {
        return this.biome.m_47554_();
    }

    @Override
    public boolean isHighHumidity() {
        return this.biome.m_47533_();
    }

    @Override
    public float getDownfall() {
        return this.biome.m_47548_();
    }

    @Override
    public boolean isFake() {
        return false;
    }
}

