/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.library;

import com.google.gson.reflect.TypeToken;
import dynamiclabs.immersivefx.dsurround.DynamicSurroundings;
import dynamiclabs.immersivefx.environs.Environs;
import dynamiclabs.immersivefx.environs.config.Config;
import dynamiclabs.immersivefx.environs.library.BiomeAdapter;
import dynamiclabs.immersivefx.environs.library.BiomeEvaluator;
import dynamiclabs.immersivefx.environs.library.BiomeInfo;
import dynamiclabs.immersivefx.environs.library.BiomeUtil;
import dynamiclabs.immersivefx.environs.library.DimensionInfo;
import dynamiclabs.immersivefx.environs.library.DimensionLibrary;
import dynamiclabs.immersivefx.environs.library.FakeBiomeAdapter;
import dynamiclabs.immersivefx.environs.library.WTFFakeBiomeAdapter;
import dynamiclabs.immersivefx.environs.library.config.BiomeConfig;
import dynamiclabs.immersivefx.lib.fml.ForgeUtils;
import dynamiclabs.immersivefx.lib.logging.IModLog;
import dynamiclabs.immersivefx.lib.math.MathStuff;
import dynamiclabs.immersivefx.lib.resource.IResourceAccessor;
import dynamiclabs.immersivefx.lib.resource.ResourceUtils;
import dynamiclabs.immersivefx.lib.service.IModuleService;
import dynamiclabs.immersivefx.lib.service.ModuleServiceManager;
import dynamiclabs.immersivefx.lib.validation.ListValidator;
import dynamiclabs.immersivefx.lib.validation.Validators;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class BiomeLibrary {
    private static final IModLog LOGGER = Environs.LOGGER.createChild(BiomeLibrary.class);
    private static final int INSIDE_Y_ADJUST = 3;
    public static final FakeBiomeAdapter UNDERGROUND = new FakeBiomeAdapter("Underground");
    public static final FakeBiomeAdapter PLAYER = new FakeBiomeAdapter("Player");
    public static final FakeBiomeAdapter UNDERWATER = new FakeBiomeAdapter("Underwater");
    public static final FakeBiomeAdapter UNDEROCEAN = new FakeBiomeAdapter("UnderOCN");
    public static final FakeBiomeAdapter UNDERDEEPOCEAN = new FakeBiomeAdapter("UnderDOCN");
    public static final FakeBiomeAdapter UNDERRIVER = new FakeBiomeAdapter("UnderRVR");
    public static final FakeBiomeAdapter OUTERSPACE = new FakeBiomeAdapter("OuterSpace");
    public static final FakeBiomeAdapter CLOUDS = new FakeBiomeAdapter("Clouds");
    public static final FakeBiomeAdapter VILLAGE = new FakeBiomeAdapter("Village");
    private static final FakeBiomeAdapter WTF = new WTFFakeBiomeAdapter();
    public static final BiomeInfo UNDERGROUND_INFO = UNDERGROUND.getBiomeData();
    public static final BiomeInfo PLAYER_INFO = PLAYER.getBiomeData();
    public static final BiomeInfo UNDERRIVER_INFO = UNDERRIVER.getBiomeData();
    public static final BiomeInfo UNDEROCEAN_INFO = UNDEROCEAN.getBiomeData();
    public static final BiomeInfo UNDERDEEPOCEAN_INFO = UNDERDEEPOCEAN.getBiomeData();
    public static final BiomeInfo UNDERWATER_INFO = UNDERWATER.getBiomeData();
    public static final BiomeInfo OUTERSPACE_INFO = OUTERSPACE.getBiomeData();
    public static final BiomeInfo CLOUDS_INFO = CLOUDS.getBiomeData();
    public static final BiomeInfo VILLAGE_INFO = VILLAGE.getBiomeData();
    public static final BiomeInfo WTF_INFO = WTF.getBiomeData();
    private static final ObjectOpenHashSet<FakeBiomeAdapter> theFakes = new ObjectOpenHashSet();

    private BiomeLibrary() {
    }

    static void initialize() {
        ModuleServiceManager.instance().add(new BiomeLibraryService());
    }

    static void initFromConfig(@Nonnull List<BiomeConfig> cfg) {
        if (cfg.size() > 0) {
            BiomeEvaluator evaluator = new BiomeEvaluator();
            for (BiomeInfo bi : BiomeLibrary.getCombinedStream()) {
                evaluator.update(bi);
                for (BiomeConfig c : cfg) {
                    if (!evaluator.matches(c.conditions)) continue;
                    try {
                        bi.update(c);
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Unable to process biome sound configuration [%s]", c.toString());
                    }
                }
            }
        }
    }

    @Nonnull
    public static BiomeInfo getPlayerBiome(@Nonnull Player player, boolean getTrue) {
        Biome biome = (Biome)player.m_20193_().m_204166_(new BlockPos(player.m_20185_(), 0.0, player.m_20189_())).m_203334_();
        BiomeInfo info = BiomeUtil.getBiomeData(biome);
        if (!getTrue) {
            if (player.m_204029_(FluidTags.f_13131_)) {
                info = info.isRiver() ? UNDERRIVER_INFO : (info.isDeepOcean() ? UNDERDEEPOCEAN_INFO : (info.isOcean() ? UNDEROCEAN_INFO : UNDERWATER_INFO));
            } else {
                DimensionInfo dimInfo = DimensionLibrary.getData(player.m_20193_());
                int theY = MathStuff.floor(player.m_20186_());
                if (theY + 3 <= dimInfo.getSeaLevel()) {
                    info = UNDERGROUND_INFO;
                } else if (theY >= dimInfo.getSpaceHeight()) {
                    info = OUTERSPACE_INFO;
                } else if (theY >= dimInfo.getCloudHeight()) {
                    info = CLOUDS_INFO;
                }
            }
        }
        return info;
    }

    private static Collection<BiomeInfo> getCombinedStream() {
        return Stream.concat(ForgeUtils.getBiomes().stream().map(BiomeUtil::getBiomeData), theFakes.stream().map(FakeBiomeAdapter::getBiomeData)).collect(Collectors.toCollection(ArrayList::new));
    }

    static {
        theFakes.add((Object)UNDERGROUND);
        theFakes.add((Object)PLAYER);
        theFakes.add((Object)UNDERWATER);
        theFakes.add((Object)UNDEROCEAN);
        theFakes.add((Object)UNDERDEEPOCEAN);
        theFakes.add((Object)UNDERRIVER);
        theFakes.add((Object)OUTERSPACE);
        theFakes.add((Object)CLOUDS);
        theFakes.add((Object)VILLAGE);
        theFakes.add((Object)WTF);
    }

    static class BiomeLibraryService
    implements IModuleService {
        private static final Type biomeType = TypeToken.getParameterized(List.class, (Type[])new Type[]{BiomeConfig.class}).getType();

        BiomeLibraryService() {
        }

        @Override
        public String name() {
            return "BiomeLibrary";
        }

        @Override
        public void start() {
            ForgeUtils.getBiomes().forEach(b -> {
                BiomeAdapter handler = new BiomeAdapter((Biome)b);
                BiomeUtil.setBiomeData(b, new BiomeInfo(handler));
            });
            Registry biomeRegistry = ((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122885_);
            BiomeUtil.getBiomeData((Biome)biomeRegistry.m_6246_(Biomes.f_48202_));
            BiomeUtil.getBiomeData((Biome)biomeRegistry.m_6246_(Biomes.f_48173_));
            Collection<IResourceAccessor> configs = ResourceUtils.findConfigs("dsurround", DynamicSurroundings.DATA_PATH, "biomes.json");
            IResourceAccessor.process(configs, accessor -> BiomeLibrary.initFromConfig((List)accessor.as(biomeType)));
        }

        @Override
        public void log() {
            if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
                LOGGER.info("*** BIOME REGISTRY ***", new Object[0]);
                BiomeLibrary.getCombinedStream().stream().sorted().map(Object::toString).forEach(x$0 -> LOGGER.info((String)x$0, new Object[0]));
            }
            BiomeLibrary.getCombinedStream().forEach(BiomeInfo::trim);
        }

        @Override
        public void stop() {
            ForgeUtils.getBiomes().forEach(b -> BiomeUtil.setBiomeData(b, null));
            Registry biomeRegistry = ((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122885_);
            BiomeUtil.setBiomeData((Biome)biomeRegistry.m_6246_(Biomes.f_48202_), null);
            BiomeUtil.setBiomeData((Biome)biomeRegistry.m_6246_(Biomes.f_48173_), null);
        }

        static {
            Validators.registerValidator(biomeType, new ListValidator());
        }
    }
}

