/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.library;

import dynamiclabs.immersivefx.environs.library.BiomeAdapter;
import dynamiclabs.immersivefx.environs.library.BiomeInfo;
import dynamiclabs.immersivefx.environs.misc.IMixinBiomeData;
import dynamiclabs.immersivefx.lib.biomes.BiomeUtilities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class BiomeUtil {
    @Nonnull
    public static BiomeInfo getBiomeData(@Nonnull Biome biome) {
        BiomeInfo result = ((IMixinBiomeData)biome).getInfo();
        if (result == null) {
            Biome forge = BiomeUtilities.getClientBiome(biome);
            if (forge != null) {
                result = ((IMixinBiomeData)forge).getInfo();
            }
            if (result == null) {
                BiomeAdapter handler = new BiomeAdapter(biome);
                result = new BiomeInfo(handler);
            }
            ((IMixinBiomeData)biome).setInfo(result);
        }
        return result;
    }

    public static void setBiomeData(@Nonnull Biome biome, @Nullable BiomeInfo data) {
        ((IMixinBiomeData)biome).setInfo(data);
    }
}

