/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;

public final class SoundTypeUtils {
    private static final Reference2ObjectOpenHashMap<SoundType, String> soundTypeMap = new Reference2ObjectOpenHashMap();
    private static final Map<String, SoundType> soundTypeMapInv = new TreeMap<String, SoundType>(String.CASE_INSENSITIVE_ORDER);

    private SoundTypeUtils() {
    }

    public static void forEach(@Nonnull Consumer<SoundType> consumer) {
        for (SoundType type : soundTypeMap.keySet()) {
            consumer.accept(type);
        }
    }

    @Nullable
    public static SoundType getSoundType(@Nonnull String name) {
        return soundTypeMapInv.get(name);
    }

    @Nullable
    public static String getSoundTypeName(@Nonnull SoundType st) {
        return (String)soundTypeMap.get((Object)st);
    }

    public static boolean isStepSoundValid(@Nullable SoundType st) {
        return st != null && SoundTypeUtils.isValid(st.m_56776_());
    }

    public static boolean isValid(@Nonnull SoundEvent se) {
        return se != null && se.m_11660_() != null;
    }

    static {
        soundTypeMap.defaultReturnValue((Object)"CUSTOM");
        soundTypeMap.put((Object)SoundType.f_56736_, (Object)"WOOD");
        soundTypeMap.put((Object)SoundType.f_56739_, (Object)"GROUND");
        soundTypeMap.put((Object)SoundType.f_56740_, (Object)"PLANT");
        soundTypeMap.put((Object)SoundType.f_56741_, (Object)"LILY_PADS");
        soundTypeMap.put((Object)SoundType.f_56742_, (Object)"STONE");
        soundTypeMap.put((Object)SoundType.f_56743_, (Object)"METAL");
        soundTypeMap.put((Object)SoundType.f_56744_, (Object)"GLASS");
        soundTypeMap.put((Object)SoundType.f_56745_, (Object)"CLOTH");
        soundTypeMap.put((Object)SoundType.f_56746_, (Object)"SAND");
        soundTypeMap.put((Object)SoundType.f_56747_, (Object)"SNOW");
        soundTypeMap.put((Object)SoundType.f_56748_, (Object)"LADDER");
        soundTypeMap.put((Object)SoundType.f_56749_, (Object)"ANVIL");
        soundTypeMap.put((Object)SoundType.f_56750_, (Object)"SLIME");
        soundTypeMap.put((Object)SoundType.f_56751_, (Object)"HONEY");
        soundTypeMap.put((Object)SoundType.f_56752_, (Object)"WET_GRASS");
        soundTypeMap.put((Object)SoundType.f_56753_, (Object)"CORAL");
        soundTypeMap.put((Object)SoundType.f_56754_, (Object)"BAMBOO");
        soundTypeMap.put((Object)SoundType.f_56755_, (Object)"BAMBOO_SAPLING");
        soundTypeMap.put((Object)SoundType.f_56756_, (Object)"SCAFFOLDING");
        soundTypeMap.put((Object)SoundType.f_56757_, (Object)"SWEET_BERRY_BUSH");
        soundTypeMap.put((Object)SoundType.f_56758_, (Object)"CROP");
        soundTypeMap.put((Object)SoundType.f_56759_, (Object)"STEM");
        soundTypeMap.put((Object)SoundType.f_56760_, (Object)"VINE");
        soundTypeMap.put((Object)SoundType.f_56761_, (Object)"NETHER_WART");
        soundTypeMap.put((Object)SoundType.f_56762_, (Object)"LANTERN");
        soundTypeMap.put((Object)SoundType.f_56763_, (Object)"HYPHAE");
        soundTypeMap.put((Object)SoundType.f_56710_, (Object)"NYLIUM");
        soundTypeMap.put((Object)SoundType.f_56711_, (Object)"FUNGUS");
        soundTypeMap.put((Object)SoundType.f_56712_, (Object)"ROOT");
        soundTypeMap.put((Object)SoundType.f_56713_, (Object)"SHROOMLIGHT");
        soundTypeMap.put((Object)SoundType.f_56714_, (Object)"NETHER_VINE");
        soundTypeMap.put((Object)SoundType.f_56715_, (Object)"NETHER_VINE_LOWER_PITCH");
        soundTypeMap.put((Object)SoundType.f_56716_, (Object)"SOUL_SAND");
        soundTypeMap.put((Object)SoundType.f_56717_, (Object)"SOUL_SOIL");
        soundTypeMap.put((Object)SoundType.f_56718_, (Object)"BASALT");
        soundTypeMap.put((Object)SoundType.f_56719_, (Object)"WART");
        soundTypeMap.put((Object)SoundType.f_56720_, (Object)"NETHERRACK");
        soundTypeMap.put((Object)SoundType.f_56721_, (Object)"NETHER_BRICK");
        soundTypeMap.put((Object)SoundType.f_56722_, (Object)"NETHER_SPROUT");
        soundTypeMap.put((Object)SoundType.f_56723_, (Object)"NETHER_ORE");
        soundTypeMap.put((Object)SoundType.f_56724_, (Object)"BONE");
        soundTypeMap.put((Object)SoundType.f_56725_, (Object)"NETHERITE");
        soundTypeMap.put((Object)SoundType.f_56726_, (Object)"ANCIENT_DEBRIS");
        soundTypeMap.put((Object)SoundType.f_56727_, (Object)"LODESTONE");
        soundTypeMap.put((Object)SoundType.f_56728_, (Object)"CHAIN");
        soundTypeMap.put((Object)SoundType.f_56729_, (Object)"NETHER_GOLD");
        soundTypeMap.put((Object)SoundType.f_56730_, (Object)"GILDED_BLACKSTONE");
        for (Map.Entry kvp : soundTypeMap.entrySet()) {
            soundTypeMapInv.put((String)kvp.getValue(), (SoundType)kvp.getKey());
        }
    }
}

