/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.blockstate;

import com.google.common.collect.ImmutableMap;
import dynamiclabs.immersivefx.lib.Lib;
import dynamiclabs.immersivefx.lib.logging.IModLog;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public final class BlockStateParser {
    private static final IModLog LOGGER = Lib.LOGGER;

    private BlockStateParser() {
    }

    @Nonnull
    public static Optional<ParseResult> parseBlockState(@Nonnull String blockName) {
        String temp = blockName;
        int idx = temp.indexOf(43);
        String extras = null;
        if (idx > 0) {
            extras = temp.substring(idx + 1);
            temp = temp.substring(0, idx);
        }
        Object properties = ImmutableMap.of();
        idx = temp.indexOf(91);
        if (idx > 0) {
            try {
                int end = temp.indexOf(93);
                String propString = temp.substring(idx + 1, end);
                properties = Arrays.stream(propString.split(",")).map(elem -> elem.split("=")).collect(Collectors.toMap(e -> e[0], e -> e[1]));
                temp = temp.substring(0, idx);
            }
            catch (Throwable ignore) {
                LOGGER.warn("Unable to parse properties of '%s'", blockName);
                return Optional.empty();
            }
        }
        if (!ResourceLocation.m_135830_((String)temp)) {
            LOGGER.warn("Invalid blockname '%s' for entry '%s'", temp, blockName);
            return Optional.empty();
        }
        ResourceLocation resource = new ResourceLocation(temp);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resource);
        if (block == null || block == Blocks.f_50016_ && !"mincraft:air".equals(temp)) {
            LOGGER.warn("Unknown block '%s' for entry '%s'", temp, blockName);
            return Optional.empty();
        }
        return Optional.of(new ParseResult(temp, block, (Map<String, String>)properties, extras));
    }

    public static final class ParseResult {
        @Nonnull
        private final String blockName;
        @Nonnull
        private final Block block;
        @Nonnull
        private final Map<String, String> properties;
        @Nullable
        private final String extras;

        private ParseResult(@Nonnull String blockName, @Nonnull Block block, @Nonnull Map<String, String> props, @Nullable String extras) {
            this.blockName = blockName;
            this.block = block;
            this.properties = props;
            this.extras = extras;
        }

        @Nonnull
        public String getBlockName() {
            return this.blockName;
        }

        @Nonnull
        public Block getBlock() {
            return this.block;
        }

        public boolean hasProperties() {
            return this.properties.size() > 0;
        }

        @Nonnull
        public Map<String, String> getProperties() {
            return this.properties;
        }

        public boolean hasExtras() {
            return !StringUtils.isEmpty((CharSequence)this.extras);
        }

        @Nullable
        public String getExtras() {
            return this.extras;
        }

        @Nonnull
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getBlockName());
            if (this.hasProperties()) {
                builder.append('[');
                String props = this.getProperties().entrySet().stream().map(Objects::toString).collect(Collectors.joining(","));
                builder.append(props);
                builder.append(']');
            }
            if (!StringUtils.isEmpty((CharSequence)this.extras)) {
                builder.append('+').append(this.extras);
            }
            return builder.toString();
        }
    }
}

