/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.math;

import javax.annotation.Nonnull;

public class EMA {
    private final String name;
    private final double factor;
    private double ema;

    public EMA() {
        this("UNNAMED");
    }

    public EMA(@Nonnull String name) {
        this(name, 100);
    }

    public EMA(@Nonnull String name, int periods) {
        this.name = name;
        this.factor = 2.0 / (double)(periods + 1);
        this.ema = Double.NaN;
    }

    public double update(double newValue) {
        this.ema = Double.isNaN(this.ema) ? newValue : (newValue - this.ema) * this.factor + this.ema;
        return this.ema;
    }

    public String name() {
        return this.name;
    }

    public double get() {
        return this.ema;
    }
}

