/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.particles;

import dynamiclabs.immersivefx.lib.collections.ObjectArray;
import dynamiclabs.immersivefx.lib.events.DiagnosticEvent;
import dynamiclabs.immersivefx.lib.particles.IParticleCollection;
import dynamiclabs.immersivefx.lib.particles.ParticleCollectionHelper;
import dynamiclabs.immersivefx.sndctrl.config.Config;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sndctrl", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class CollectionManager {
    private static final ObjectArray<ParticleCollectionHelper> helpers = new ObjectArray();

    private CollectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IParticleCollection create(@Nonnull String name, @Nonnull ParticleRenderType renderType) {
        ParticleCollectionHelper helper = new ParticleCollectionHelper(name, renderType);
        ObjectArray<ParticleCollectionHelper> objectArray = helpers;
        synchronized (objectArray) {
            helpers.add(helper);
        }
        return helper;
    }

    @SubscribeEvent
    public static void onWorldUnload(@Nonnull WorldEvent.Unload event) {
        if (event.getWorld() instanceof ClientLevel) {
            helpers.forEach(ParticleCollectionHelper::clear);
        }
    }

    @SubscribeEvent
    public static void diagnostics(@Nonnull DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            helpers.forEach(h -> {
                event.getLeft().add(ChatFormatting.AQUA + h.toString());
                h.getRenderTimer().ifPresent(event::addRenderTimer);
                h.getTickTimer().ifPresent(event::addRenderTimer);
            });
        }
    }
}

