/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.scripting.sets;

import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.WorldUtils;
import dynamiclabs.immersivefx.lib.scripting.VariableSet;
import dynamiclabs.immersivefx.lib.scripting.sets.IDimensionVariables;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DimensionVariables
extends VariableSet<IDimensionVariables>
implements IDimensionVariables {
    private String id;
    private String name;
    private boolean hasSky;
    private boolean isSuperFlat;

    public DimensionVariables() {
        super("dim");
    }

    @Override
    @Nonnull
    public IDimensionVariables getInterface() {
        return this;
    }

    @Override
    public void update() {
        if (GameUtils.isInGame()) {
            assert (GameUtils.getWorld() != null);
            DimensionType dim = GameUtils.getWorld().m_6042_();
            ResourceLocation location = GameUtils.getWorld().m_46472_().m_135782_();
            this.id = location.toString();
            this.hasSky = dim.m_63935_();
            this.name = location.m_135815_();
            this.isSuperFlat = WorldUtils.isSuperFlat((Level)GameUtils.getWorld());
        } else {
            this.id = "UNKNOWN";
            this.hasSky = false;
            this.name = "UNKNOWN";
            this.isSuperFlat = false;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDimName() {
        return this.name;
    }

    @Override
    public boolean hasSky() {
        return this.hasSky;
    }

    @Override
    public boolean isSuperFlat() {
        return this.isSuperFlat;
    }
}

