/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.scripting.sets;

import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.WorldUtils;
import dynamiclabs.immersivefx.lib.scripting.VariableSet;
import dynamiclabs.immersivefx.lib.scripting.sets.IWeatherVariables;
import dynamiclabs.immersivefx.lib.scripting.sets.LazyVariable;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WeatherVariables
extends VariableSet<IWeatherVariables>
implements IWeatherVariables {
    private final LazyVariable<Float> temperature = new LazyVariable<Float>(() -> {
        if (GameUtils.isInGame()) {
            ClientLevel world = GameUtils.getWorld();
            BlockPos pos = GameUtils.getPlayer().m_142538_();
            return Float.valueOf(WorldUtils.getTemperatureAt((Level)world, pos));
        }
        return Float.valueOf(0.0f);
    });
    private boolean isRaining;
    private boolean isThundering;
    private float rainIntensity;
    private float thunderIndensity;

    public WeatherVariables() {
        super("weather");
    }

    @Override
    @Nonnull
    public IWeatherVariables getInterface() {
        return this;
    }

    @Override
    public void update() {
        if (GameUtils.isInGame()) {
            ClientLevel world = GameUtils.getWorld();
            this.rainIntensity = WorldUtils.getRainStrength((Level)world, 1.0f);
            this.thunderIndensity = WorldUtils.getThunderStrength((Level)world, 1.0f);
            this.isRaining = WorldUtils.isRaining((Level)world);
            this.isThundering = WorldUtils.isThundering((Level)world);
        } else {
            this.rainIntensity = 0.0f;
            this.thunderIndensity = 0.0f;
            this.isRaining = false;
            this.isThundering = false;
        }
        this.temperature.reset();
    }

    @Override
    public boolean isRaining() {
        return this.isRaining;
    }

    @Override
    public boolean isThundering() {
        return this.isThundering;
    }

    @Override
    public float getRainIntensity() {
        return this.rainIntensity;
    }

    @Override
    public float getThunderIntensity() {
        return this.thunderIndensity;
    }

    @Override
    public float getTemperature() {
        return this.temperature.get().floatValue();
    }
}

