/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.shaders;

import dynamiclabs.immersivefx.lib.gui.Color;
import dynamiclabs.immersivefx.lib.shaders.ShaderProgram;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL20;

@OnlyIn(value=Dist.CLIENT)
public final class ShaderCallContext {
    private final ShaderProgram program;

    ShaderCallContext(@Nonnull ShaderProgram program) {
        this.program = program;
    }

    public void set(@Nonnull String uniform, float value) {
        GL20.glUniform1f((int)this.getUniform(uniform), (float)value);
    }

    public void set(@Nonnull String uniform, float v1, float v2) {
        GL20.glUniform2f((int)this.getUniform(uniform), (float)v1, (float)v2);
    }

    public void set(@Nonnull String uniform, @Nonnull Color color) {
        this.set(uniform, color, 1.0f);
    }

    public void set(@Nonnull String uniform, @Nonnull Color color, float alpha) {
        float[] params = new float[]{color.red(), color.green(), color.blue(), alpha};
        GL20.glUniform4fv((int)this.getUniform(uniform), (float[])params);
    }

    public void set(@Nonnull String uniform, int ... values) {
        GL20.glUniform1iv((int)this.getUniform(uniform), (int[])values);
    }

    private int getUniform(@Nonnull String name) {
        return this.program.getUniform(name);
    }
}

