/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.mobeffects.effects;

import dynamiclabs.immersivefx.mobeffects.config.Config;
import dynamiclabs.immersivefx.mobeffects.effects.FactoryHandler;
import dynamiclabs.immersivefx.mobeffects.footsteps.FootprintStyle;
import dynamiclabs.immersivefx.mobeffects.footsteps.Generator;
import dynamiclabs.immersivefx.mobeffects.library.FootstepLibrary;
import dynamiclabs.immersivefx.sndctrl.api.effects.AbstractEntityEffect;
import dynamiclabs.immersivefx.sndctrl.api.effects.IEntityEffectManager;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntityFootprintEffect
extends AbstractEntityEffect {
    private static final ResourceLocation NAME = new ResourceLocation("mobeffects", "footprint");
    public static final FactoryHandler FACTORY = new FactoryHandler(NAME, entity -> entity instanceof Player ? new PlayerFootprintEffect() : new EntityFootprintEffect());
    protected Generator generator;

    public EntityFootprintEffect() {
        super(NAME);
    }

    @Override
    public void intitialize(@Nonnull IEntityEffectManager state) {
        super.intitialize(state);
        this.generator = FootstepLibrary.createGenerator(this.getEntity());
    }

    @Override
    public void update() {
        this.generator.generateFootsteps(this.getEntity());
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.generator.getPedometer();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class PlayerFootprintEffect
    extends EntityFootprintEffect {
        protected FootprintStyle lastStyle;

        private PlayerFootprintEffect() {
        }

        @Override
        public void intitialize(@Nonnull IEntityEffectManager state) {
            super.intitialize(state);
            this.lastStyle = (FootprintStyle)((Object)Config.CLIENT.footsteps.playerFootprintStyle.get());
        }

        @Override
        public void update() {
            FootprintStyle currentStyle = (FootprintStyle)((Object)Config.CLIENT.footsteps.playerFootprintStyle.get());
            if (this.lastStyle != currentStyle) {
                this.generator = FootstepLibrary.createGenerator(this.getEntity());
                this.lastStyle = currentStyle;
            }
            super.update();
        }
    }
}

