/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.mobeffects.effects;

import dynamiclabs.immersivefx.mobeffects.library.EffectLibrary;
import dynamiclabs.immersivefx.sndctrl.api.effects.AbstractEntityEffect;
import dynamiclabs.immersivefx.sndctrl.api.effects.IEntityEffectFactoryHandler;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FactoryHandler
implements IEntityEffectFactoryHandler {
    private final ResourceLocation name;
    private final Function<LivingEntity, AbstractEntityEffect> factory;

    public FactoryHandler(@Nonnull ResourceLocation res, @Nonnull Function<LivingEntity, AbstractEntityEffect> factory) {
        this.name = res;
        this.factory = factory;
    }

    @Override
    @Nonnull
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public boolean appliesTo(@Nonnull LivingEntity entity) {
        return EffectLibrary.hasEffect((Entity)entity, this.getName());
    }

    @Override
    @Nonnull
    public AbstractEntityEffect get(@Nonnull LivingEntity entity) {
        return this.factory.apply(entity);
    }
}

