/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.audio;

import com.google.common.collect.ImmutableList;
import dynamiclabs.immersivefx.sndctrl.api.sound.Category;
import dynamiclabs.immersivefx.sndctrl.api.sound.ISoundCategory;
import dynamiclabs.immersivefx.sndctrl.library.config.SoundMetadataConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public final class SoundMetadata {
    private static final Component NO_STRING = TextComponent.f_131282_;
    private final Component title;
    private final Component caption;
    private final ISoundCategory category;
    private final List<Component> credits;

    public SoundMetadata() {
        this.title = NO_STRING;
        this.caption = NO_STRING;
        this.category = Category.NEUTRAL;
        this.credits = ImmutableList.of();
    }

    public SoundMetadata(@Nonnull SoundMetadataConfig cfg) {
        Objects.requireNonNull(cfg);
        this.title = StringUtils.isEmpty((CharSequence)cfg.title) ? NO_STRING : new TranslatableComponent(cfg.title);
        this.caption = StringUtils.isEmpty((CharSequence)cfg.caption) ? NO_STRING : new TranslatableComponent(cfg.caption);
        this.category = Category.getCategory(cfg.category).orElse(Category.NEUTRAL);
        if (cfg.credits == null || cfg.credits.size() == 0) {
            this.credits = ImmutableList.of();
        } else {
            this.credits = new ArrayList<Component>();
            for (String s : cfg.credits) {
                if (StringUtils.isEmpty((CharSequence)s)) {
                    this.credits.add(NO_STRING);
                    continue;
                }
                this.credits.add((Component)new TextComponent(s));
            }
        }
    }

    @Nonnull
    public Component getTitle() {
        return this.title;
    }

    @Nonnull
    public Component getCaption() {
        return this.caption;
    }

    @Nonnull
    public List<Component> getCredits() {
        return this.credits;
    }

    @Nonnull
    public ISoundCategory getCategory() {
        return this.category;
    }
}

