/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.audio.acoustic;

import com.google.common.base.MoreObjects;
import dynamiclabs.immersivefx.lib.WeightTable;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.AcousticEvent;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcousticFactory;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProbabilityAcoustic
implements IAcoustic {
    protected final ResourceLocation name;
    protected final WeightTable<IAcoustic> table;

    public ProbabilityAcoustic(@Nonnull ResourceLocation name) {
        this.name = Objects.requireNonNull(name);
        this.table = new WeightTable();
    }

    public void add(@Nonnull IAcoustic acoustic, int weight) {
        this.table.add(acoustic, weight);
    }

    public void trim() {
        this.table.trim();
    }

    @Nonnull
    private Optional<IAcoustic> select() {
        return Optional.ofNullable(this.table.next());
    }

    @Override
    @Nonnull
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public void play(@Nonnull AcousticEvent event) {
        this.select().ifPresent(a -> a.play(event));
    }

    @Override
    public void playAt(@Nonnull BlockPos pos, @Nonnull AcousticEvent event) {
        this.select().ifPresent(a -> a.playAt(pos, event));
    }

    @Override
    public void playAt(@Nonnull Vec3 pos, @Nonnull AcousticEvent event) {
        this.select().ifPresent(a -> a.playAt(pos, event));
    }

    @Override
    public void playNear(@Nonnull Entity entity, @Nonnull AcousticEvent event) {
        this.select().ifPresent(a -> a.playNear(entity, event));
    }

    @Override
    public void playNear(@Nonnull Entity entity, @Nonnull AcousticEvent event, int minRange, int maxRange) {
        this.select().ifPresent(a -> a.playNear(entity, event, minRange, maxRange));
    }

    @Override
    public void playBackground(@Nonnull AcousticEvent event) {
        this.select().ifPresent(a -> a.playBackground(event));
    }

    @Override
    public IAcousticFactory getFactory(@Nonnull AcousticEvent event) {
        return this.select().map(IAcoustic::getFactory).orElse(null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getName().toString()).add("entries", this.table.size()).toString();
    }
}

