/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.client;

import com.google.common.collect.ImmutableList;
import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.MaterialUtils;
import dynamiclabs.immersivefx.lib.TickCounter;
import dynamiclabs.immersivefx.lib.blockstate.BlockStateMatcher;
import dynamiclabs.immersivefx.lib.events.DiagnosticEvent;
import dynamiclabs.immersivefx.sndctrl.config.Config;
import dynamiclabs.immersivefx.sndctrl.events.BlockInspectionEvent;
import dynamiclabs.immersivefx.sndctrl.events.EntityInspectionEvent;
import dynamiclabs.immersivefx.sndctrl.library.AudioEffectLibrary;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;

@Mod.EventBusSubscriber(modid="sndctrl", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Inspector {
    private static final String TEXT_BLOCKSTATE = ChatFormatting.DARK_PURPLE + "<BlockState>";
    private static final String TEXT_TAGS = ChatFormatting.DARK_PURPLE + "<Tags>";
    private static List<String> diagnostics = ImmutableList.of();

    private Inspector() {
    }

    private static List<String> getTags(@Nonnull BlockState state) {
        return state.m_60734_().m_204297_().m_203616_().map(t -> "#" + t.f_203868_()).toList();
    }

    private static void gatherBlockText(ItemStack stack, List<String> text, BlockState state, BlockPos pos) {
        BlockStateMatcher info;
        if (!stack.m_41619_()) {
            text.add(ChatFormatting.RED + stack.m_41786_().getString());
            String itemName = stack.m_41720_().m_41466_().getString();
            if (!StringUtils.isEmpty((CharSequence)itemName)) {
                text.add("ITEM: " + itemName);
                text.add(ChatFormatting.DARK_AQUA + stack.m_41720_().getClass().getName());
            }
        }
        if (state != null && !(info = BlockStateMatcher.create(state)).isEmpty()) {
            text.add("BLOCK: " + info.toString());
            text.add(ChatFormatting.DARK_AQUA + info.getBlock().getClass().getName());
            text.add("Material: " + MaterialUtils.getMaterialName(state.m_60767_()));
            SoundType st = state.m_60827_();
            text.add("Step Sound: " + st.m_56776_().getRegistryName().toString());
            text.add("Reflectivity: " + AudioEffectLibrary.getReflectivity(state));
            text.add("Occlusion: " + AudioEffectLibrary.getOcclusion(state));
            text.add(TEXT_BLOCKSTATE);
            CompoundTag nbt = NbtUtils.m_129202_((BlockState)state);
            text.add(nbt.toString());
            List<String> tagNames = Inspector.getTags(state);
            if (tagNames.size() > 0) {
                text.add(TEXT_TAGS);
                for (String ore : tagNames) {
                    text.add(ChatFormatting.GOLD + ore);
                }
            }
        }
    }

    private static boolean isHolding() {
        Player player = GameUtils.getPlayer();
        if (player == null) {
            return false;
        }
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        return !held.m_41619_() && held.m_41720_() == Items.f_42684_;
    }

    @SubscribeEvent
    public static void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (TickCounter.getTickCount() % 5L == 0L) {
            diagnostics = ImmutableList.of();
            if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue() && Inspector.isHolding()) {
                ClientLevel world = GameUtils.getWorld();
                if (GameUtils.getMC().f_91076_ != null) {
                    EntityInspectionEvent evt = new EntityInspectionEvent(GameUtils.getMC().f_91076_);
                    evt.data.add(ChatFormatting.RED + "Entity " + evt.entity.toString());
                    MinecraftForge.EVENT_BUS.post((Event)evt);
                    diagnostics = evt.data;
                } else {
                    BlockState state;
                    BlockHitResult trace;
                    HitResult current = GameUtils.getMC().f_91077_;
                    if (current instanceof BlockHitResult && (trace = (BlockHitResult)current).m_6662_() != HitResult.Type.MISS && !(state = world.m_8055_(trace.m_82425_())).m_60795_()) {
                        BlockInspectionEvent evt = new BlockInspectionEvent(trace, (Level)world, state, trace.m_82425_());
                        MinecraftForge.EVENT_BUS.post((Event)evt);
                        diagnostics = evt.data;
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockInspectionEvent(@Nonnull BlockInspectionEvent event) {
        ItemStack stack = event.state.m_60734_().getCloneItemStack(event.state, (HitResult)event.rayTrace, (BlockGetter)event.world, event.pos, GameUtils.getPlayer());
        Inspector.gatherBlockText(stack, event.data, event.state, event.pos);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onGatherText(@Nonnull DiagnosticEvent event) {
        event.getLeft().addAll(diagnostics);
    }
}

