/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.fml.ForgeUtils;
import dynamiclabs.immersivefx.lib.gui.ColorPalette;
import dynamiclabs.immersivefx.lib.gui.GuiHelpers;
import dynamiclabs.immersivefx.sndctrl.api.sound.Category;
import dynamiclabs.immersivefx.sndctrl.api.sound.ISoundCategory;
import dynamiclabs.immersivefx.sndctrl.api.sound.ISoundInstance;
import dynamiclabs.immersivefx.sndctrl.api.sound.SoundBuilder;
import dynamiclabs.immersivefx.sndctrl.audio.AudioEngine;
import dynamiclabs.immersivefx.sndctrl.audio.SoundMetadata;
import dynamiclabs.immersivefx.sndctrl.library.IndividualSoundConfig;
import dynamiclabs.immersivefx.sndctrl.library.SoundLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.Slider;

@OnlyIn(value=Dist.CLIENT)
public class IndividualSoundControlListEntry
extends ContainerObjectSelectionList.Entry<IndividualSoundControlListEntry>
implements Slider.ISlider,
AutoCloseable {
    private static final int SLIDER_WIDTH = 100;
    private static final int BUTTON_WIDTH = 60;
    private static final int TOOLTIP_WIDTH = 300;
    private static final Button.OnPress NULL_PRESSABLE = b -> {};
    private static final Component CULL_ON = new TranslatableComponent("sndctrl.text.soundconfig.cull");
    private static final Component CULL_OFF = new TranslatableComponent("sndctrl.text.soundconfig.nocull");
    private static final Component BLOCK_ON = new TranslatableComponent("sndctrl.text.soundconfig.block");
    private static final Component BLOCK_OFF = new TranslatableComponent("sndctrl.text.soundconfig.noblock");
    private static final Component PLAY = new TranslatableComponent("sndctrl.text.soundconfig.play");
    private static final Component STOP = new TranslatableComponent("sndctrl.text.soundconfig.stop");
    private static final Component VANILLA_CREDIT = new TranslatableComponent("sndctrl.text.tooltip.vanilla");
    private static final Component SLIDER_SUFFIX = new TextComponent("%");
    private static final ChatFormatting[] CODING = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.AQUA};
    private static final Collection<Component> VOLUME_HELP = GuiHelpers.getTrimmedTextCollection("sndctrl.text.soundconfig.volume.help", 300, CODING);
    private static final Collection<Component> PLAY_HELP = GuiHelpers.getTrimmedTextCollection("sndctrl.text.soundconfig.play.help", 300, CODING);
    private static final Collection<Component> CULL_HELP = GuiHelpers.getTrimmedTextCollection("sndctrl.text.soundconfig.cull.help", 300, CODING);
    private static final Collection<Component> BLOCK_HELP = GuiHelpers.getTrimmedTextCollection("sndctrl.text.soundconfig.block.help", 300, CODING);
    private static final int CONTROL_SPACING = 3;
    private final IndividualSoundConfig config;
    private final Slider volume;
    private final Button blockButton;
    private final Button cullButton;
    private final Button playButton;
    private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    private List<Component> defaultTooltip;
    private ISoundInstance soundPlay;

    public IndividualSoundControlListEntry(@Nonnull IndividualSoundConfig data, boolean enablePlay) {
        this.config = data;
        this.volume = new Slider(0, 0, 100, 0, TextComponent.f_131282_, SLIDER_SUFFIX, 0.0, 400.0, (double)this.config.getVolumeScaleInt(), false, true, NULL_PRESSABLE, (Slider.ISlider)this);
        this.children.add((AbstractWidget)this.volume);
        this.blockButton = new Button(0, 0, 60, 0, this.config.isBlocked() ? BLOCK_ON : BLOCK_OFF, this::toggleBlock);
        this.children.add((AbstractWidget)this.blockButton);
        this.cullButton = new Button(0, 0, 60, 0, this.config.isCulled() ? CULL_ON : CULL_OFF, this::toggleCull);
        this.children.add((AbstractWidget)this.cullButton);
        this.playButton = new Button(0, 0, 60, 0, PLAY, this::play){

            public void m_7435_(@Nonnull SoundManager ignore) {
            }
        };
        this.playButton.f_93623_ = enablePlay;
        this.children.add((AbstractWidget)this.playButton);
    }

    @Nonnull
    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    public void m_6311_(@Nonnull PoseStack matrixStack, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick_) {
        Font font = GameUtils.getMC().f_91062_;
        float f = rowTop;
        Objects.requireNonNull(font);
        float labelY = f + (float)(rowHeight - 9) / 2.0f;
        String text = this.config.getLocation().toString();
        font.m_92883_(matrixStack, text, (float)rowLeft, labelY, ColorPalette.WHITE.rgb());
        int rightMargin = rowLeft + rowWidth;
        this.volume.f_93620_ = rightMargin - this.volume.m_5711_();
        this.volume.f_93621_ = rowTop;
        this.volume.setHeight(rowHeight);
        this.playButton.f_93620_ = (rightMargin -= this.volume.m_5711_() + 3) - this.playButton.m_5711_();
        this.playButton.f_93621_ = rowTop;
        this.playButton.setHeight(rowHeight);
        this.blockButton.f_93620_ = (rightMargin -= this.playButton.m_5711_() + 3) - this.blockButton.m_5711_();
        this.blockButton.f_93621_ = rowTop;
        this.blockButton.setHeight(rowHeight);
        this.cullButton.f_93620_ = (rightMargin -= this.blockButton.m_5711_() + 3) - this.cullButton.m_5711_();
        this.cullButton.setHeight(rowHeight);
        this.cullButton.f_93621_ = rowTop;
        for (AbstractWidget w : this.children) {
            w.m_6305_(matrixStack, mouseX, mouseY, partialTick_);
        }
    }

    protected void toggleBlock(@Nonnull Button button) {
        this.config.setIsBlocked(!this.config.isBlocked());
        button.m_93666_(this.config.isBlocked() ? BLOCK_ON : BLOCK_OFF);
    }

    protected void toggleCull(@Nonnull Button button) {
        this.config.setIsCulled(!this.config.isCulled());
        button.m_93666_(this.config.isCulled() ? CULL_ON : CULL_OFF);
    }

    public void onChangeSliderValue(@Nonnull Slider slider) {
        this.config.setVolumeScaleInt(slider.getValueInt());
    }

    protected void play(@Nonnull Button button) {
        if (this.soundPlay == null) {
            Optional<SoundEvent> event = SoundLibrary.getSound(this.config.getLocation());
            event.ifPresent(se -> {
                this.soundPlay = SoundBuilder.builder(se, Category.CONFIG).setGlobal(true).setVolume(this.config.getVolumeScale()).build();
                AudioEngine.play(this.soundPlay);
                this.playButton.m_93666_(STOP);
            });
        } else {
            AudioEngine.stop(this.soundPlay);
            this.soundPlay = null;
            this.playButton.m_93666_(PLAY);
        }
    }

    @Override
    public void close() {
        if (this.soundPlay != null) {
            AudioEngine.stop(this.soundPlay);
            this.soundPlay = null;
        }
    }

    public void tick() {
        if (this.soundPlay != null && this.soundPlay.getState().isTerminal()) {
            this.soundPlay = null;
            this.playButton.m_93666_(PLAY);
        }
    }

    @Nonnull
    protected List<Component> getToolTip(int mouseX, int mouseY) {
        if (this.defaultTooltip == null) {
            ISoundCategory category;
            this.defaultTooltip = new ArrayList<Component>();
            ResourceLocation loc = this.config.getLocation();
            String modName = ForgeUtils.getModDisplayName(loc.m_135827_());
            this.defaultTooltip.add((Component)new TextComponent(ChatFormatting.GOLD + modName));
            this.defaultTooltip.add((Component)new TextComponent(ChatFormatting.GRAY + loc.toString()));
            SoundMetadata meta = SoundLibrary.getSoundMetadata(loc);
            Component title = meta.getTitle();
            if (title != TextComponent.f_131282_) {
                this.defaultTooltip.add(title);
            }
            if ((category = meta.getCategory()) != Category.NEUTRAL) {
                this.defaultTooltip.add((Component)new TranslatableComponent("sndctrl.text.tooltip.category").m_7220_(category.getTextComponent()));
            }
            if (modName.equals("Minecraft")) {
                this.defaultTooltip.add(VANILLA_CREDIT);
            } else {
                this.defaultTooltip.addAll(meta.getCredits());
            }
        }
        ArrayList<Component> result = new ArrayList<Component>(this.defaultTooltip);
        if (this.volume.m_5953_((double)mouseX, (double)mouseY)) {
            result.addAll(VOLUME_HELP);
        } else if (this.blockButton.m_5953_((double)mouseX, (double)mouseY)) {
            result.addAll(BLOCK_HELP);
        } else if (this.cullButton.m_5953_((double)mouseX, (double)mouseY)) {
            result.addAll(CULL_HELP);
        } else if (this.playButton.m_5953_((double)mouseX, (double)mouseY)) {
            result.addAll(PLAY_HELP);
        }
        return result;
    }

    @Nonnull
    public IndividualSoundConfig getData() {
        return this.config;
    }

    public List<? extends NarratableEntry> m_142437_() {
        return null;
    }
}

