/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.library;

import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import dynamiclabs.immersivefx.dsurround.DynamicSurroundings;
import dynamiclabs.immersivefx.lib.MaterialUtils;
import dynamiclabs.immersivefx.lib.blockstate.BlockStateMatcherMap;
import dynamiclabs.immersivefx.lib.fml.ForgeUtils;
import dynamiclabs.immersivefx.lib.logging.IModLog;
import dynamiclabs.immersivefx.lib.math.MathStuff;
import dynamiclabs.immersivefx.lib.resource.IResourceAccessor;
import dynamiclabs.immersivefx.lib.resource.ResourceUtils;
import dynamiclabs.immersivefx.lib.service.IModuleService;
import dynamiclabs.immersivefx.lib.service.ModuleServiceManager;
import dynamiclabs.immersivefx.lib.tags.TagUtils;
import dynamiclabs.immersivefx.sndctrl.SoundControl;
import dynamiclabs.immersivefx.sndctrl.misc.IMixinAudioEffectData;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.tags.ITag;

@OnlyIn(value=Dist.CLIENT)
public final class AudioEffectLibrary {
    private static final String MATERIAL_PREFIX = "+";
    private static final String TAG_PREFIX = "#";
    private static final float DEFAULT_OPAQUE_OCCLUSION = 0.5f;
    private static final float DEFAULT_TRANSLUCENT_OCCLUSION = 0.15f;
    private static final float DEFAULT_REFLECTION = 0.4f;
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(AudioEffectLibrary.class);
    private static final Object2FloatOpenHashMap<Material> materialOcclusion = new Object2FloatOpenHashMap();
    private static final BlockStateMatcherMap<Float> blockStateOcclusionMap = new BlockStateMatcherMap();
    private static final Object2FloatOpenHashMap<Material> materialReflect = new Object2FloatOpenHashMap();
    private static final BlockStateMatcherMap<Float> blockStateReflectMap = new BlockStateMatcherMap();
    private static final Object2FloatOpenHashMap<ResourceLocation> fluidCoefficient = new Object2FloatOpenHashMap();

    public static void initialize() {
        ModuleServiceManager.instance().add(new AudioEffectLibraryService());
    }

    public static float getOcclusion(@Nonnull BlockState state) {
        return AudioEffectLibrary.resolve((BlockState)state).occlusion;
    }

    public static float getReflectivity(@Nonnull BlockState state) {
        return AudioEffectLibrary.resolve((BlockState)state).reflectivity;
    }

    private static EffectData resolve(@Nonnull BlockState state) {
        IMixinAudioEffectData accessor = (IMixinAudioEffectData)state;
        EffectData data = accessor.getData();
        if (data == null) {
            float o = AudioEffectLibrary.resolveOcclusion(state);
            float r = AudioEffectLibrary.resolveReflectivity(state);
            data = new EffectData(o, r);
            accessor.setData(data);
        }
        return data;
    }

    private static float resolveReflectivity(@Nonnull BlockState state) {
        Float result = blockStateReflectMap.get(state);
        if (result == null || result.floatValue() < 0.0f) {
            result = Float.valueOf(materialReflect.getFloat((Object)state.m_60767_()));
        }
        return result.floatValue() < 0.0f ? 0.4f : result.floatValue();
    }

    private static float resolveOcclusion(@Nonnull BlockState state) {
        Float result = blockStateOcclusionMap.get(state);
        if ((result == null || result.floatValue() < 0.0f) && (result = Float.valueOf(materialOcclusion.getFloat((Object)state.m_60767_()))).floatValue() < 0.0f) {
            result = Float.valueOf(state.m_60767_().m_76337_() ? 0.5f : 0.15f);
        }
        return result.floatValue();
    }

    public static float getFluidCoeffcient(@Nonnull ResourceLocation res) {
        return fluidCoefficient.getFloat((Object)res);
    }

    private static void processOcclusions(@Nonnull EffectOptions options) {
        for (Map.Entry<String, Float> kvp : options.occlusions.entrySet()) {
            String name = kvp.getKey();
            if (name.startsWith(MATERIAL_PREFIX)) {
                String materialName = name.substring(1);
                Material mat = MaterialUtils.getMaterial(materialName);
                if (mat != null) {
                    materialOcclusion.put((Object)mat, kvp.getValue().floatValue());
                    continue;
                }
                LOGGER.debug("Unrecognized material name: %s", materialName);
                continue;
            }
            if (name.startsWith(TAG_PREFIX)) {
                String tagName = name.substring(1);
                ITag<Block> tag = TagUtils.getBlockTag(tagName);
                for (Block block : tag.stream().toList()) {
                    for (BlockState state : block.m_49965_().m_61056_()) {
                        blockStateOcclusionMap.put(state, kvp.getValue());
                    }
                }
                continue;
            }
            try {
                blockStateOcclusionMap.put(name, kvp.getValue());
            }
            catch (Throwable t) {
                LOGGER.error(t, "Unable to insert entry into block state map: %s", t.getMessage());
            }
        }
        blockStateOcclusionMap.put(Blocks.f_50016_, Float.valueOf(0.0f));
        blockStateOcclusionMap.put(Blocks.f_50627_, Float.valueOf(0.0f));
        blockStateOcclusionMap.put(Blocks.f_50626_, Float.valueOf(0.0f));
    }

    private static void processReflectivity(@Nonnull EffectOptions options) {
        for (Map.Entry<String, Float> kvp : options.reflectivity.entrySet()) {
            String name = kvp.getKey();
            float val = MathStuff.clamp(kvp.getValue().floatValue(), 0.0f, 2.0f);
            if (name.startsWith(MATERIAL_PREFIX)) {
                String materialName = name.substring(1);
                Material mat = MaterialUtils.getMaterial(materialName);
                if (mat != null) {
                    materialReflect.put((Object)mat, val);
                    continue;
                }
                LOGGER.debug("Unrecognized material name: %s", materialName);
                continue;
            }
            if (name.startsWith(TAG_PREFIX)) {
                String tagName = name.substring(1);
                ITag<Block> tag = TagUtils.getBlockTag(tagName);
                for (Block block : tag.stream().toList()) {
                    for (BlockState state : block.m_49965_().m_61056_()) {
                        blockStateReflectMap.put(state, Float.valueOf(val));
                    }
                }
                continue;
            }
            try {
                blockStateReflectMap.put(name, Float.valueOf(val));
            }
            catch (Throwable t) {
                LOGGER.error(t, "Unable to insert entry into block state map: %s", t.getMessage());
            }
        }
        blockStateReflectMap.put(Blocks.f_50016_, Float.valueOf(0.0f));
        blockStateReflectMap.put(Blocks.f_50627_, Float.valueOf(0.0f));
        blockStateReflectMap.put(Blocks.f_50626_, Float.valueOf(0.0f));
    }

    private static void processLowpass(@Nonnull EffectOptions options) {
        for (Map.Entry<String, Float> kvp : options.fluid.entrySet()) {
            fluidCoefficient.put((Object)new ResourceLocation(kvp.getKey()), kvp.getValue().floatValue());
        }
    }

    private static class AudioEffectLibraryService
    implements IModuleService {
        private AudioEffectLibraryService() {
        }

        @Override
        public String name() {
            return "AudioEffectLibrary";
        }

        @Override
        public void start() {
            materialOcclusion.defaultReturnValue(-1.0f);
            for (Material mat : MaterialUtils.getMaterials()) {
                materialOcclusion.put((Object)mat, mat.m_76337_() ? 0.5f : 0.15f);
            }
            blockStateOcclusionMap.setDefaultValue(() -> Float.valueOf(-1.0f));
            materialReflect.defaultReturnValue(-1.0f);
            blockStateReflectMap.setDefaultValue(() -> Float.valueOf(-1.0f));
            fluidCoefficient.defaultReturnValue(0.0f);
            fluidCoefficient.put((Object)new ResourceLocation("sndctrl:default"), 0.0f);
            Collection<IResourceAccessor> configs = ResourceUtils.findConfigs("dsurround", DynamicSurroundings.DATA_PATH, "effects.json");
            IResourceAccessor.process(configs, accessor -> {
                EffectOptions cfg = accessor.as(EffectOptions.class);
                AudioEffectLibrary.processOcclusions(cfg);
                AudioEffectLibrary.processReflectivity(cfg);
                AudioEffectLibrary.processLowpass(cfg);
            });
        }

        @Override
        public void stop() {
            materialOcclusion.clear();
            materialReflect.clear();
            blockStateOcclusionMap.clear();
            blockStateReflectMap.clear();
            fluidCoefficient.clear();
            ForgeUtils.getBlockStates().forEach(state -> {
                IMixinAudioEffectData accessor = (IMixinAudioEffectData)state;
                accessor.setData(null);
            });
        }

        @Override
        public void reload() {
            this.stop();
            this.start();
        }
    }

    public static class EffectData {
        public final float occlusion;
        public final float reflectivity;

        public EffectData(float o, float r) {
            this.occlusion = o;
            this.reflectivity = r;
        }
    }

    public static class EffectOptions {
        @SerializedName(value="occlusions")
        public Map<String, Float> occlusions = ImmutableMap.of();
        @SerializedName(value="reflectivity")
        public Map<String, Float> reflectivity = ImmutableMap.of();
        @SerializedName(value="fluid")
        public Map<String, Float> fluid = ImmutableMap.of();
    }
}

