/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.library;

import dynamiclabs.immersivefx.lib.collections.ObjectArray;
import dynamiclabs.immersivefx.sndctrl.SoundControl;
import dynamiclabs.immersivefx.sndctrl.api.effects.AbstractEntityEffect;
import dynamiclabs.immersivefx.sndctrl.api.effects.IEntityEffectFactoryHandler;
import dynamiclabs.immersivefx.sndctrl.config.Config;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class EntityEffectLibrary {
    private static final ObjectArray<IEntityEffectFactoryHandler> entityEffectfactoryHandlers = new ObjectArray();

    private EntityEffectLibrary() {
    }

    public static void initialize() {
    }

    public static void complete() {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            SoundControl.LOGGER.info("Registered Handlers", new Object[0]);
            SoundControl.LOGGER.info("===================", new Object[0]);
            for (IEntityEffectFactoryHandler h : entityEffectfactoryHandlers) {
                SoundControl.LOGGER.info(h.getName().toString(), new Object[0]);
            }
        }
    }

    @Nonnull
    public static ObjectArray<AbstractEntityEffect> getEffects(@Nonnull LivingEntity entity) {
        ObjectArray<AbstractEntityEffect> result = new ObjectArray<AbstractEntityEffect>();
        entityEffectfactoryHandlers.forEach(h -> {
            if (h.appliesTo(entity)) {
                result.add(h.get(entity));
            }
        });
        result.trim();
        return result;
    }

    public static void register(@Nonnull IEntityEffectFactoryHandler handler) {
        entityEffectfactoryHandlers.add(handler);
    }
}

