/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.library;

import dynamiclabs.immersivefx.lib.SoundTypeUtils;
import dynamiclabs.immersivefx.lib.Utilities;
import dynamiclabs.immersivefx.lib.resource.ResourceUtils;
import dynamiclabs.immersivefx.mobeffects.library.Constants;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.api.sound.ISoundCategory;
import dynamiclabs.immersivefx.sndctrl.audio.acoustic.AcousticCompiler;
import dynamiclabs.immersivefx.sndctrl.audio.acoustic.NullAcoustic;
import dynamiclabs.immersivefx.sndctrl.audio.acoustic.SimpleAcoustic;
import dynamiclabs.immersivefx.sndctrl.library.AcousticLibrary;
import dynamiclabs.immersivefx.sndctrl.library.SoundLibrary;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Primitives {
    private static final float MINECRAFT_VOLUME_SCALE = 0.15f;
    private static final String ARMOR_EQUIP_PREFIX = "primitive/armor/equip/";
    private static final String ARMOR_ACCENT_PREFIX = "primitive/armor/accent/";
    private static final String FOOTSTEP_PREFIX = "primitive/block/step/";
    private static final String VANILLA_FOOTSTEP_PREFIX = "primitive/block/step/vanilla/";
    private static final String SOUND_PREFIX = "primitive/sound/";
    private static final ResourceLocation ARMOR_TEMPLATE = new ResourceLocation("sndctrl", "templates/primitive_armor_accent.json");
    private static final ResourceLocation FOOTSTEP_TEMPLATE = new ResourceLocation("sndctrl", "templates/primitive_block_step.json");

    @Nonnull
    public static ResourceLocation createArmorToolbarResource(@Nonnull ArmorMaterial material) {
        return new ResourceLocation("mobeffects", Utilities.safeResourcePath(ARMOR_EQUIP_PREFIX + material.m_6082_()));
    }

    @Nonnull
    public static ResourceLocation createArmorAccentResource(@Nonnull ArmorMaterial material) {
        return new ResourceLocation("mobeffects", Utilities.safeResourcePath(ARMOR_ACCENT_PREFIX + material.m_6082_()));
    }

    @Nonnull
    public static ResourceLocation createFootstepResource(@Nonnull SoundType st) {
        return Primitives.createFootstepResource(SoundTypeUtils.getSoundTypeName(st));
    }

    @Nonnull
    public static ResourceLocation createVanillaFootstepResource(@Nonnull SoundType st) {
        String safePath = Utilities.safeResourcePath(VANILLA_FOOTSTEP_PREFIX + SoundTypeUtils.getSoundTypeName(st));
        return new ResourceLocation("mobeffects", safePath);
    }

    @Nonnull
    public static ResourceLocation createFootstepResource(@Nonnull String soundType) {
        String safePath = Utilities.safeResourcePath(FOOTSTEP_PREFIX + soundType);
        return new ResourceLocation("mobeffects", safePath);
    }

    @Nonnull
    private static ResourceLocation createSoundLocation(@Nonnull ResourceLocation loc, @Nonnull ISoundCategory category) {
        String safePath = Utilities.safeResourcePath(SOUND_PREFIX + category.getName() + "/" + loc.toString());
        return new ResourceLocation("mobeffects", safePath);
    }

    @Nonnull
    public static IAcoustic getSound(@Nonnull ResourceLocation loc, @Nonnull ISoundCategory category) {
        Optional<SoundEvent> se;
        ResourceLocation resource = Primitives.createSoundLocation(loc, category);
        IAcoustic acoustic = AcousticLibrary.resolve(resource);
        if (acoustic == NullAcoustic.INSTANCE && (se = SoundLibrary.getSound(loc)).isPresent() && se.get() != SoundLibrary.MISSING) {
            acoustic = new SimpleAcoustic(se.get(), category);
            AcousticLibrary.addAcoustic(resource, acoustic);
        }
        return acoustic;
    }

    @Nonnull
    public static IAcoustic getArmorToolbarAcoustic(@Nonnull ArmorMaterial material) {
        SoundEvent event;
        ResourceLocation loc = Primitives.createArmorToolbarResource(material);
        IAcoustic acoustic = AcousticLibrary.resolve(loc);
        if (acoustic == NullAcoustic.INSTANCE && SoundTypeUtils.isValid(event = material.m_7344_())) {
            acoustic = new SimpleAcoustic(event, Constants.TOOLBAR);
            AcousticLibrary.addAcoustic(loc, acoustic);
        }
        return acoustic;
    }

    @Nonnull
    public static IAcoustic getArmorAccentAcoustic(@Nonnull ArmorMaterial material) {
        SoundEvent event;
        ResourceLocation loc = Primitives.createArmorAccentResource(material);
        IAcoustic acoustic = AcousticLibrary.resolve(loc);
        if (acoustic == NullAcoustic.INSTANCE && SoundTypeUtils.isValid(event = material.m_7344_())) {
            acoustic = Primitives.generateAcousticFromTemplate(ARMOR_TEMPLATE, loc, event.m_11660_());
            AcousticLibrary.addAcoustic(loc, acoustic);
            return acoustic;
        }
        return Primitives.footstepAcousticResolver(loc, material.m_7344_());
    }

    @Nonnull
    public static IAcoustic getFootstepAcoustic(@Nonnull BlockState state) {
        return Primitives.getFootstepAcoustic(state.m_60827_());
    }

    @Nonnull
    public static IAcoustic getVanillaFootstepAcoustic(@Nonnull SoundType soundType) {
        ResourceLocation loc = Primitives.createVanillaFootstepResource(soundType);
        return Primitives.footstepAcousticResolver(loc, soundType, true);
    }

    @Nonnull
    public static IAcoustic getFootstepAcoustic(@Nonnull SoundType soundType) {
        ResourceLocation loc = Primitives.createFootstepResource(soundType);
        return Primitives.footstepAcousticResolver(loc, soundType, false);
    }

    @Nonnull
    private static IAcoustic footstepAcousticResolver(@Nonnull ResourceLocation loc, @Nonnull SoundEvent soundType) {
        IAcoustic acoustic = AcousticLibrary.resolve(loc);
        if (acoustic == NullAcoustic.INSTANCE && SoundTypeUtils.isValid(soundType)) {
            SimpleAcoustic simple = new SimpleAcoustic(soundType, Constants.FOOTSTEPS);
            simple.getFactory().setVolume(0.375f);
            AcousticLibrary.addAcoustic(loc, simple);
            acoustic = simple;
        }
        return acoustic;
    }

    @Nonnull
    private static IAcoustic footstepAcousticResolver(@Nonnull ResourceLocation loc, @Nonnull SoundType soundType, boolean isVanilla) {
        IAcoustic acoustic = AcousticLibrary.resolve(loc);
        if (acoustic == NullAcoustic.INSTANCE && SoundTypeUtils.isStepSoundValid(soundType)) {
            if (isVanilla) {
                SimpleAcoustic simple = new SimpleAcoustic(soundType.m_56776_(), Constants.FOOTSTEPS);
                simple.getFactory().setVolume(soundType.m_56773_() * 0.375f);
                simple.getFactory().setPitch(soundType.m_56774_());
                AcousticLibrary.addAcoustic(loc, simple);
                acoustic = simple;
            } else {
                acoustic = Primitives.generateAcousticFromTemplate(FOOTSTEP_TEMPLATE, loc, soundType.m_56776_().m_11660_());
            }
        }
        return acoustic;
    }

    private static IAcoustic generateAcousticFromTemplate(@Nonnull ResourceLocation template, @Nonnull ResourceLocation name, @Nonnull ResourceLocation acousticName) {
        try {
            String jsonResource = ResourceUtils.readResource(template);
            if (jsonResource != null) {
                jsonResource = jsonResource.replaceAll("<NAME>", name.toString()).replaceAll("<ACOUSTIC>", acousticName.toString());
                List<IAcoustic> acoustic = new AcousticCompiler("mobeffects").compile(jsonResource);
                return acoustic.get(0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return NullAcoustic.INSTANCE;
    }
}

