/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kobolds.entity;

import javax.annotation.Nullable;
import net.mcreator.kobolds.goal.KoboldRevengeGoal;
import net.mcreator.kobolds.goal.KoboldShieldGoal;
import net.mcreator.kobolds.goal.KoboldTridentAttackGoal;
import net.mcreator.kobolds.procedures.KoboldBaseTickProcedure;
import net.mcreator.kobolds.procedures.KoboldDeathProcedure;
import net.mcreator.kobolds.procedures.KoboldSpawnProcedure;
import net.mcreator.kobolds.procedures.KoboldTraderInteractionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractKoboldEntity
extends Monster
implements CrossbowAttackMob,
RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_STATE = SynchedEntityData.m_135353_(AbstractKoboldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean partyKobold;
    @Nullable
    private BlockPos jukebox;

    protected AbstractKoboldEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.f_21364_ = 4;
        this.m_21557_(false);
        this.m_21530_();
        this.m_21553_(true);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 14.0f, 1.2, 1.8));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creeper.class, 4.0f, 1.2, 1.6));
        this.f_21346_.m_25352_(0, (Goal)new KoboldRevengeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new KoboldShieldGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new KoboldTridentAttackGoal(this, 1.0, 40, 10.0f));
        this.f_21345_.m_25352_(1, (Goal)new RangedCrossbowAttackGoal((Monster)this, 1.0, 21.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22276_, 18.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        return builder;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6935_(Player player) {
        return false;
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.15;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.m_21205_().m_41720_() instanceof CrossbowItem) {
            this.m_32336_((LivingEntity)this, 6.0f);
        } else if (this.m_21206_().m_41720_() instanceof TridentItem) {
            ThrownTrident trident = new ThrownTrident(this.f_19853_, (LivingEntity)this, new ItemStack((ItemLike)Items.f_42713_));
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20227_(0.3333333333333333) - trident.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            trident.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
            this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)trident);
            this.getPersistentData().m_128347_("TimerTrident", 1200.0);
        }
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_5811_(LivingEntity arg0, ItemStack arg1, Projectile arg2, float arg3) {
        this.m_32322_((LivingEntity)this, arg0, arg2, arg3, 1.6f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CHARGING_STATE, (Object)false);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGING_STATE);
    }

    public void m_6136_(boolean charging) {
        this.f_19804_.m_135381_(DATA_CHARGING_STATE, (Object)charging);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_8107_() {
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 12.76) || !this.f_19853_.m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.partyKobold = false;
            this.jukebox = null;
        }
        super.m_8107_();
    }

    public void m_6818_(BlockPos pos, boolean boop) {
        this.jukebox = pos;
        this.partyKobold = boop;
    }

    public boolean isPartyKobold() {
        return this.partyKobold;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("kobolds:kobold_idle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        if (this.m_21254_()) {
            return SoundEvents.f_12346_;
        }
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("kobolds:kobold_hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("kobolds:kobold_death"));
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        AbstractKoboldEntity entity = this;
        Level world = this.f_19853_;
        if (source.m_7640_() instanceof Zombie) {
            Zombie zombie = (Zombie)source.m_7640_();
            KoboldDeathProcedure.execute((LevelAccessor)world, (Entity)entity, (Entity)zombie);
        }
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        super.m_6071_(sourceentity, hand);
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        AbstractKoboldEntity entity = this;
        Level world = this.f_19853_;
        KoboldTraderInteractionProcedure.execute((LevelAccessor)world, (Entity)entity, (Entity)sourceentity);
        return InteractionResult.FAIL;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        AbstractKoboldEntity entity = this;
        KoboldSpawnProcedure.execute((Entity)entity);
        return retval;
    }

    public void m_6075_() {
        super.m_6075_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        AbstractKoboldEntity entity = this;
        Level world = this.f_19853_;
        KoboldBaseTickProcedure.execute((LevelAccessor)world, (Entity)entity);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof Projectile) {
            Projectile proj = (Projectile)source.m_7640_();
            if (proj.m_37282_() instanceof AbstractKoboldEntity) {
                return false;
            }
        } else {
            if (source.m_7640_() instanceof AbstractKoboldEntity) {
                return false;
            }
            if (source == DamageSource.f_19305_) {
                return false;
            }
        }
        return super.m_6469_(source, amount);
    }
}

