/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import me.shedaniel.rei.api.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextType;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringResultImpl;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FilteringContextImpl
implements FilteringContext {
    private final boolean async;
    public final Map<FilteringContextType, Set<HashedEntryStackWrapper>> stacks;

    public FilteringContextImpl(Collection<EntryStack<?>> allStacks) {
        this(true, allStacks);
    }

    public FilteringContextImpl(boolean async, Collection<EntryStack<?>> allStacks) {
        this.async = async;
        this.stacks = Maps.newHashMap();
        for (FilteringContextType type : FilteringContextType.values()) {
            this.stacks.computeIfAbsent(type, t -> Sets.newHashSet());
        }
        this.stacks.get((Object)FilteringContextType.DEFAULT).addAll(async ? CollectionUtils.mapParallel(allStacks, HashedEntryStackWrapper::new) : CollectionUtils.map(allStacks, HashedEntryStackWrapper::new));
    }

    public FilteringContextImpl(Map<FilteringContextType, Set<HashedEntryStackWrapper>> stacks) {
        this.async = false;
        this.stacks = stacks;
        for (FilteringContextType type : FilteringContextType.values()) {
            this.stacks.computeIfAbsent(type, t -> Sets.newHashSet());
        }
    }

    @Override
    public Collection<EntryStack<?>> getHiddenStacks() {
        return this.getPublicFacing(FilteringContextType.HIDDEN);
    }

    @Override
    public Collection<EntryStack<?>> getShownStacks() {
        return this.getPublicFacing(FilteringContextType.SHOWN);
    }

    @Override
    public Collection<EntryStack<?>> getUnsetStacks() {
        return this.getPublicFacing(FilteringContextType.DEFAULT);
    }

    private Collection<EntryStack<?>> getPublicFacing(FilteringContextType type) {
        final Set<HashedEntryStackWrapper> wrappers = this.stacks.get((Object)type);
        if (wrappers == null || wrappers.isEmpty()) {
            return List.of();
        }
        return new AbstractSet<EntryStack<?>>(){

            @Override
            public Iterator<EntryStack<?>> iterator() {
                return Iterators.transform(wrappers.iterator(), HashedEntryStackWrapper::unwrap);
            }

            @Override
            public int size() {
                return wrappers.size();
            }
        };
    }

    public void handleResult(FilteringResultImpl result) {
        Set<HashedEntryStackWrapper> hiddenStacks = result.hiddenStacks;
        Set<HashedEntryStackWrapper> shownStacks = result.shownStacks;
        if (this.async) {
            ArrayList completableFutures = Lists.newArrayList();
            completableFutures.add(CompletableFuture.runAsync(() -> {
                this.stacks.get((Object)FilteringContextType.DEFAULT).removeAll(hiddenStacks);
                this.stacks.get((Object)FilteringContextType.DEFAULT).removeAll(shownStacks);
            }));
            completableFutures.add(CompletableFuture.runAsync(() -> {
                this.stacks.get((Object)FilteringContextType.SHOWN).removeAll(hiddenStacks);
                this.stacks.get((Object)FilteringContextType.SHOWN).addAll(shownStacks);
            }));
            completableFutures.add(CompletableFuture.runAsync(() -> {
                this.stacks.get((Object)FilteringContextType.HIDDEN).addAll(hiddenStacks);
                this.stacks.get((Object)FilteringContextType.HIDDEN).removeAll(shownStacks);
            }));
            try {
                CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
            }
        } else {
            this.stacks.get((Object)FilteringContextType.DEFAULT).removeAll(hiddenStacks);
            this.stacks.get((Object)FilteringContextType.DEFAULT).removeAll(shownStacks);
            this.stacks.get((Object)FilteringContextType.SHOWN).removeAll(hiddenStacks);
            this.stacks.get((Object)FilteringContextType.SHOWN).addAll(shownStacks);
            this.stacks.get((Object)FilteringContextType.HIDDEN).addAll(hiddenStacks);
            this.stacks.get((Object)FilteringContextType.HIDDEN).removeAll(shownStacks);
        }
    }
}

