/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering.rules;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.api.client.entry.filtering.FilteringResult;
import me.shedaniel.rei.api.client.entry.filtering.FilteringResultFactory;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.entry.filtering.rules.BasicFilteringRuleType;
import me.shedaniel.rei.impl.client.util.ThreadCreator;
import org.jetbrains.annotations.NotNull;

public enum BasicFilteringRuleImpl implements BasicFilteringRule<Pair<LongSet, LongSet>>
{
    INSTANCE;

    private static final ExecutorService EXECUTOR_SERVICE;
    private final List<EntryStack<?>> hidden = new ArrayList();
    private final List<EntryStack<?>> shown = new ArrayList();

    @Override
    public FilteringRuleType<? extends FilteringRule<Pair<LongSet, LongSet>>> getType() {
        return BasicFilteringRuleType.INSTANCE;
    }

    @Override
    public Pair<LongSet, LongSet> prepareCache(boolean async) {
        return new Pair((Object)BasicFilteringRuleImpl.prepareCacheFor(this.hidden, async), (Object)BasicFilteringRuleImpl.prepareCacheFor(this.shown, async));
    }

    @NotNull
    private static LongSet prepareCacheFor(List<EntryStack<?>> stacks, boolean async) {
        if (async) {
            LongOpenHashSet all = new LongOpenHashSet();
            ArrayList completableFutures = Lists.newArrayList();
            for (Iterable iterable : CollectionUtils.partition(stacks, 100)) {
                completableFutures.add(CompletableFuture.supplyAsync(() -> {
                    LongOpenHashSet output = new LongOpenHashSet();
                    for (EntryStack stack : partitionStacks) {
                        if (stack == null || stack.isEmpty()) continue;
                        output.add(EntryStacks.hashExact(stack));
                    }
                    return output;
                }, EXECUTOR_SERVICE));
            }
            try {
                CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
            }
            for (CompletableFuture completableFuture : completableFutures) {
                LongSet now = completableFuture.getNow(null);
                if (now == null) continue;
                all.addAll((LongCollection)now);
            }
            return all;
        }
        return (LongSet)stacks.stream().map(EntryStacks::hashExact).collect(Collectors.toCollection(LongOpenHashSet::new));
    }

    @Override
    public FilteringResult processFilteredStacks(FilteringContext context, FilteringResultFactory resultFactory, Pair<LongSet, LongSet> cache, boolean async) {
        FilteringResult result = resultFactory.create();
        this.hideList(context.getShownStacks(), result, async, (LongSet)cache.getFirst());
        this.hideList(context.getUnsetStacks(), result, async, (LongSet)cache.getFirst());
        this.showList(context.getHiddenStacks(), result, async, (LongSet)cache.getSecond());
        this.showList(context.getUnsetStacks(), result, async, (LongSet)cache.getSecond());
        return result;
    }

    private void hideList(Collection<EntryStack<?>> stacks, FilteringResult result, boolean async, LongSet filteredStacks) {
        result.hide((async ? stacks.parallelStream() : stacks.stream()).filter(stack -> filteredStacks.contains(EntryStacks.hashExact(stack))).collect(Collectors.toList()));
    }

    private void showList(Collection<EntryStack<?>> stacks, FilteringResult result, boolean async, LongSet filteredStacks) {
        result.show((async ? stacks.parallelStream() : stacks.stream()).filter(stack -> filteredStacks.contains(EntryStacks.hashExact(stack))).collect(Collectors.toList()));
    }

    @Override
    public FilteringResult hide(EntryStack<?> stack) {
        this.hidden.add(stack);
        this.shown.remove(stack);
        return this;
    }

    @Override
    public FilteringResult hide(Collection<? extends EntryStack<?>> stacks) {
        this.hidden.addAll(stacks);
        this.shown.removeAll(stacks);
        return this;
    }

    @Override
    public FilteringResult show(EntryStack<?> stack) {
        this.shown.add(stack);
        this.hidden.remove(stack);
        return this;
    }

    @Override
    public FilteringResult show(Collection<? extends EntryStack<?>> stacks) {
        this.shown.addAll(stacks);
        this.hidden.removeAll(stacks);
        return this;
    }

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void startReload() {
        this.hidden.clear();
        this.shown.clear();
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerBasicEntryFiltering(this);
    }

    static {
        EXECUTOR_SERVICE = new ThreadCreator("REI-BasicFiltering").asService();
    }
}

