/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextType;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringResultImpl;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryListener;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.Nullable;

public class PreFilteredEntryList
implements EntryRegistryListener {
    private final EntryRegistry registry;
    private final MutableLong lastRefilterWarning = new MutableLong(-1L);
    private List<EntryStack<?>> preFilteredList = Lists.newCopyOnWriteArrayList();

    public PreFilteredEntryList(EntryRegistry registry) {
        this.registry = registry;
    }

    private static <T> Predicate<T> not(Predicate<? super T> target) {
        Objects.requireNonNull(target);
        return target.negate();
    }

    @Override
    public void addEntryAfter(@Nullable EntryStack<?> afterEntry, EntryStack<?> stack, long stackHashExact) {
        if (!this.registry.isReloading()) {
            int index;
            Collection<EntryStack<?>> refilterNew = this.refilterNew(true, Collections.singletonList(stack));
            if (afterEntry != null && (index = this.preFilteredList.lastIndexOf(afterEntry)) >= 0) {
                this.preFilteredList.addAll(index, refilterNew);
                this.queueSearchUpdate();
                return;
            }
            this.preFilteredList.addAll(refilterNew);
            this.queueSearchUpdate();
        }
    }

    @Override
    public void addEntriesAfter(@Nullable EntryStack<?> afterEntry, List<EntryStack<?>> stacks, @Nullable LongList hashes) {
        if (!this.registry.isReloading()) {
            int index;
            Collection<EntryStack<?>> refilterNew = this.refilterNew(true, stacks);
            if (afterEntry != null && (index = this.preFilteredList.lastIndexOf(afterEntry)) >= 0) {
                this.preFilteredList.addAll(index, refilterNew);
                this.queueSearchUpdate();
                return;
            }
            this.preFilteredList.addAll(refilterNew);
            this.queueSearchUpdate();
        }
    }

    @Override
    public void removeEntry(EntryStack<?> stack, long hashExact) {
        if (!this.registry.isReloading()) {
            this.preFilteredList.remove(stack);
            this.queueSearchUpdate();
        }
    }

    @Override
    public void removeEntries(List<EntryStack<?>> stacks, @Nullable LongList hashes) {
        if (!this.registry.isReloading()) {
            this.preFilteredList.removeAll(stacks);
            this.queueSearchUpdate();
        }
    }

    @Override
    public void removeEntriesIf(Predicate<EntryStack<?>> predicate) {
        if (!this.registry.isReloading()) {
            this.preFilteredList.removeIf(predicate);
            this.queueSearchUpdate();
        }
    }

    @Override
    public void onReFilter(List<EntryStack<?>> stacks) {
        ConfigObject config = ConfigObject.getInstance();
        if (config.getFilteredStackProviders() != null) {
            List<EntryStack> normalizedFilteredStacks = CollectionUtils.map(config.getFilteredStackProviders(), EntryStackProvider::provide);
            normalizedFilteredStacks.removeIf(EntryStack::isEmpty);
            config.getFilteredStackProviders().clear();
            config.getFilteredStackProviders().addAll(CollectionUtils.map(normalizedFilteredStacks, EntryStackProvider::ofStack));
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        FilteringContextImpl context = new FilteringContextImpl(stacks);
        HashMap cache = new HashMap();
        List<FilteringRule<?>> rules = ((ConfigObjectImpl)ConfigObject.getInstance()).getFilteringRules();
        Stopwatch innerStopwatch = Stopwatch.createStarted();
        for (int i = rules.size() - 1; i >= 0; --i) {
            innerStopwatch.reset().start();
            FilteringRule<?> rule = rules.get(i);
            cache.put(rule, rule.prepareCache(true));
            context.handleResult((FilteringResultImpl)rule.processFilteredStacks(context, () -> new FilteringResultImpl(new ArrayList(), new ArrayList()), cache.get(rule), true));
            InternalLogger.getInstance().debug("Refiltered rule [%s] in %s.", rule.getType().toString(), innerStopwatch.stop().toString());
        }
        Set<HashedEntryStackWrapper> hiddenStacks = context.stacks.get((Object)FilteringContextType.HIDDEN);
        this.preFilteredList = hiddenStacks.isEmpty() ? Lists.newCopyOnWriteArrayList(stacks) : (List)stacks.parallelStream().map(HashedEntryStackWrapper::new).filter(PreFilteredEntryList.not(hiddenStacks::contains)).map(HashedEntryStackWrapper::unwrap).collect(Collectors.toCollection(Lists::newCopyOnWriteArrayList));
        InternalLogger.getInstance().debug("Refiltered %d entries with %d rules in %s.", stacks.size() - this.preFilteredList.size(), rules.size(), stopwatch.stop().toString());
    }

    public Collection<EntryStack<?>> refilterNew(boolean warn, Collection<EntryStack<?>> entries) {
        if (this.lastRefilterWarning != null && warn) {
            if (this.lastRefilterWarning.getValue() > 0L && System.currentTimeMillis() - this.lastRefilterWarning.getValue() > 5000L) {
                InternalLogger.getInstance().warn("Detected runtime EntryRegistry modification, this can be extremely dangerous, or be extremely inefficient!");
            }
            this.lastRefilterWarning.setValue(System.currentTimeMillis());
        }
        FilteringContextImpl context = new FilteringContextImpl(entries);
        HashMap cache = new HashMap();
        List<FilteringRule<?>> rules = ((ConfigObjectImpl)ConfigObject.getInstance()).getFilteringRules();
        for (int i = rules.size() - 1; i >= 0; --i) {
            FilteringRule<?> rule = rules.get(i);
            cache.put(rule, rule.prepareCache(entries.size() > 100));
            context.handleResult((FilteringResultImpl)rule.processFilteredStacks(context, () -> new FilteringResultImpl(new ArrayList(), new ArrayList()), cache.get(rule), entries.size() > 100));
        }
        Set<HashedEntryStackWrapper> hiddenStacks = context.stacks.get((Object)FilteringContextType.HIDDEN);
        if (hiddenStacks.isEmpty()) {
            return entries;
        }
        return entries.parallelStream().map(HashedEntryStackWrapper::new).filter(PreFilteredEntryList.not(hiddenStacks::contains)).map(HashedEntryStackWrapper::unwrap).collect(Collectors.toList());
    }

    private void queueSearchUpdate() {
        REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadSearch);
    }

    public List<EntryStack<?>> getList() {
        return this.preFilteredList;
    }
}

