/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.schematic;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.schematic.ParsedSchematicObject;
import com.natamus.collective.schematic.Schematic;
import com.natamus.collective.schematic.SchematicBlockObject;
import java.io.InputStream;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ParseSchematicFile {
    public static ParsedSchematicObject getParsedSchematicObject(InputStream schematicInputStream, Level level, BlockPos centerPos, int extraYOffset, boolean skipAir) {
        Schematic schematic = new Schematic(schematicInputStream);
        int maxBuildHeight = level.m_151558_();
        short length = schematic.getLength();
        short width = schematic.getWidth();
        short height = schematic.getHeight();
        int yoffset = centerPos.m_123342_() + extraYOffset;
        if (yoffset + height > maxBuildHeight) {
            yoffset = maxBuildHeight - height;
        }
        ArrayList<Pair<BlockPos, BlockState>> blocks = new ArrayList<Pair<BlockPos, BlockState>>();
        for (SchematicBlockObject blockObject : schematic.getBlocks()) {
            BlockState blockState = blockObject.getState();
            if (skipAir && blockState.m_60734_().equals(Blocks.f_50016_)) continue;
            blocks.add((Pair<BlockPos, BlockState>)new Pair((Object)blockObject.getPosition().m_142082_(centerPos.m_123341_() - width / 2, yoffset, centerPos.m_123343_() - length / 2).m_7949_(), (Object)blockState));
        }
        ArrayList<BlockPos> blockEntityPositions = new ArrayList<BlockPos>();
        for (CompoundTag blockEntityCompoundTag : schematic.getBlockEntities()) {
            blockEntityPositions.add(schematic.getBlockPosFromCompoundTag(blockEntityCompoundTag).m_142082_(centerPos.m_123341_() - width / 2, yoffset, centerPos.m_123343_() - length / 2));
        }
        return new ParsedSchematicObject(blocks, blockEntityPositions, "Parsed successfully.", true);
    }
}

