/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.schematic;

import com.mojang.brigadier.StringReader;
import com.natamus.collective.schematic.SchematicBlockObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Schematic {
    private int size;
    private short width;
    private short height;
    private short length;
    private boolean oldVersion;
    private HashMap<Integer, String> palette;
    private SchematicBlockObject[] blockObjects;
    private List<CompoundTag> blockEntities;

    public Schematic(InputStream inputStream) {
        try {
            CompoundTag nbtdata = NbtIo.m_128939_((InputStream)inputStream);
            inputStream.close();
            this.width = nbtdata.m_128448_("Width");
            this.height = nbtdata.m_128448_("Height");
            this.length = nbtdata.m_128448_("Length");
            this.size = this.width * this.height * this.length;
            this.oldVersion = !nbtdata.m_128441_("DataVersion");
            this.blockObjects = new SchematicBlockObject[this.size];
            if (!this.oldVersion) {
                byte[] blocks = nbtdata.m_128463_("BlockData");
                CompoundTag palette = nbtdata.m_128469_("Palette");
                this.palette = new HashMap();
                for (String k : palette.m_128431_()) {
                    this.palette.put(palette.m_128451_(k), k);
                }
                int counter = 0;
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.length; ++j) {
                        for (int k = 0; k < this.width; ++k) {
                            BlockPos pos = new BlockPos(k, i, j);
                            int id = blocks[counter];
                            if (id < 0) {
                                id *= -1;
                            }
                            BlockState state = this.getStateFromID(id);
                            this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                            ++counter;
                        }
                    }
                }
                ListTag tileentitynbtlist = nbtdata.m_128437_("BlockEntities", 10);
                this.blockEntities = new ArrayList<CompoundTag>();
                for (int i = 0; i < tileentitynbtlist.size(); ++i) {
                    this.blockEntities.add(tileentitynbtlist.m_128728_(i));
                }
            } else {
                byte[] blockIDs_byte = nbtdata.m_128463_("Blocks");
                int[] blockIDs = new int[this.size];
                for (int x = 0; x < blockIDs_byte.length; ++x) {
                    blockIDs[x] = Byte.toUnsignedInt(blockIDs_byte[x]);
                }
                byte[] metadata = nbtdata.m_128463_("Data");
                int counter = 0;
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.length; ++j) {
                        for (int k = 0; k < this.width; ++k) {
                            BlockPos pos = new BlockPos(k, i, j);
                            BlockState state = this.getStateFromOldIds(blockIDs[counter], metadata[counter]);
                            this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                            ++counter;
                        }
                    }
                }
                ListTag tileentitynbtlist = nbtdata.m_128437_("TileEntities", 10);
                this.blockEntities = new ArrayList<CompoundTag>();
                for (int i = 0; i < tileentitynbtlist.size(); ++i) {
                    CompoundTag compound = tileentitynbtlist.m_128728_(i);
                    int i1 = compound.m_128451_("x");
                    int i2 = compound.m_128451_("y");
                    int i3 = compound.m_128451_("z");
                    compound.m_128385_("Pos", new int[]{i1, i2, i3});
                    this.blockEntities.add(compound);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR Cant load Schematic");
            e.printStackTrace();
            this.width = 0;
            this.height = 0;
            this.length = 0;
            this.size = 0;
            this.blockObjects = null;
            this.palette = null;
            this.blockEntities = null;
        }
    }

    public boolean isOldVersion() {
        return this.oldVersion;
    }

    private BlockState getStateFromOldIds(int blockID, byte meta) {
        return Block.m_49803_((int)blockID);
    }

    public BlockState getBlockState(BlockPos pos) {
        for (SchematicBlockObject obj : this.blockObjects) {
            if (!obj.getPosition().equals((Object)pos)) continue;
            return obj.getState();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public int getSize() {
        return this.size;
    }

    public SchematicBlockObject[] getBlocks() {
        return this.blockObjects;
    }

    public BlockState getStateFromID(int id) {
        String iblockstateS = this.palette.get(id);
        try {
            BlockStateParser parser = new BlockStateParser(new StringReader(iblockstateS), true);
            parser.m_116806_(false);
            return parser.m_116808_();
        }
        catch (Exception ex) {
            return Blocks.f_50016_.m_49966_();
        }
    }

    public List<CompoundTag> getBlockEntities() {
        return this.blockEntities;
    }

    public CompoundTag getTileEntity(BlockPos pos) {
        for (CompoundTag compound : this.blockEntities) {
            int[] pos1 = compound.m_128465_("Pos");
            if (pos1[0] != pos.m_123341_() || pos1[1] != pos.m_123342_() || pos1[2] != pos.m_123343_()) continue;
            return compound;
        }
        return null;
    }

    public BlockPos getBlockPosFromCompoundTag(CompoundTag compoundTag) {
        int[] pos = compoundTag.m_128465_("Pos");
        return new BlockPos(pos[0], pos[1], pos[2]);
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public short getLength() {
        return this.length;
    }
}

