/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.personality.client;

import com.teamabnormals.personality.core.PersonalityConfig;
import com.teamabnormals.personality.core.mixin.client.AccessibilityOptionsScreenAccessor;
import net.minecraft.client.CycleOption;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Option;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PersonalityClient {
    public static final KeyMapping CRAWL = new ToggleKeyMapping("key.personality.crawl", 67, "key.categories.gameplay", () -> ((ForgeConfigSpec.BooleanValue)PersonalityConfig.CLIENT.keybinds.toggleCrawl).get());
    public static final KeyMapping SIT = new ToggleKeyMapping("key.personality.sit", 90, "key.categories.gameplay", () -> ((ForgeConfigSpec.BooleanValue)PersonalityConfig.CLIENT.keybinds.toggleSitting).get());
    private static final Component MOVEMENT_TOGGLE = new TranslatableComponent("options.key.toggle");
    private static final Component MOVEMENT_HOLD = new TranslatableComponent("options.key.hold");
    public static final CycleOption<Boolean> TOGGLE_CRAWL = CycleOption.m_167758_((String)CRAWL.m_90860_(), (Component)MOVEMENT_TOGGLE, (Component)MOVEMENT_HOLD, options -> (Boolean)PersonalityConfig.CLIENT.keybinds.toggleCrawl.get(), (options, option, value) -> PersonalityConfig.CLIENT.keybinds.toggleCrawl.set(value));
    public static final CycleOption<Boolean> TOGGLE_SIT = CycleOption.m_167758_((String)SIT.m_90860_(), (Component)MOVEMENT_TOGGLE, (Component)MOVEMENT_HOLD, options -> (Boolean)PersonalityConfig.CLIENT.keybinds.toggleCrawl.get(), (options, option, value) -> PersonalityConfig.CLIENT.keybinds.toggleCrawl.set(value));
    private static final Logger LOGGER = LogManager.getLogger();

    public static void registerKeyBinds() {
        CRAWL.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        SIT.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        ClientRegistry.registerKeyBinding((KeyMapping)CRAWL);
        ClientRegistry.registerKeyBinding((KeyMapping)SIT);
    }

    public static void addAccessibilityOptions() {
        try {
            AccessibilityOptionsScreenAccessor.setOptions(PersonalityClient.addButtons(AccessibilityOptionsScreenAccessor.getOptions(), 10, new Option[]{TOGGLE_CRAWL, TOGGLE_SIT}));
        }
        catch (Exception e) {
            LOGGER.error("Error adding options to AccessibilityScreen", (Throwable)e);
        }
    }

    private static Option[] addButtons(Option[] src, int startingIndex, Option ... options) {
        int index = startingIndex;
        for (Option option : options) {
            Option[] tmp = new Option[src.length + 1];
            System.arraycopy(src, 0, tmp, 0, index);
            tmp[index] = option;
            System.arraycopy(src, index, tmp, index + 1, src.length - index);
            src = tmp;
            ++index;
        }
        return src;
    }
}

