/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.personality.core.mixin.client;

import com.teamabnormals.personality.common.CommonEvents;
import com.teamabnormals.personality.core.Personality;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public abstract class HumanoidModelMixin<T extends LivingEntity>
extends AgeableListModel<T> {
    @Final
    @Shadow
    public ModelPart f_102811_;
    @Final
    @Shadow
    public ModelPart f_102812_;
    @Final
    @Shadow
    public ModelPart f_102813_;
    @Final
    @Shadow
    public ModelPart f_102814_;

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="HEAD")})
    public void sitModel(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        Player player;
        if (entityIn instanceof Player && Personality.SYNCED_SITTING_PLAYERS.contains((player = (Player)entityIn).m_142081_())) {
            this.f_102609_ = true;
        }
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/model/HumanoidModel;riding:Z", shift=At.Shift.BEFORE)})
    public void climbAnimation(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (entityIn instanceof Player) {
            float f = !this.f_102609_ ? CommonEvents.getClimbingAnimationScale((Player)entityIn, Minecraft.m_91087_().m_91296_()) : 0.0f;
            float climbAnim = -f * (float)Math.PI / 2.0f;
            this.f_102811_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f + climbAnim * 1.4f;
            this.f_102812_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f + climbAnim * 1.4f;
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102811_.f_104204_ = -climbAnim * 0.4f;
            this.f_102812_.f_104204_ = climbAnim * 0.4f;
            this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + climbAnim * 0.5f;
            this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount + climbAnim * 0.5f;
            this.f_102813_.f_104204_ = 0.0f;
            this.f_102814_.f_104204_ = 0.0f;
            this.f_102813_.f_104205_ = 0.0f;
            this.f_102814_.f_104205_ = 0.0f;
        }
    }
}

