/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.block;

import com.google.common.base.Suppliers;
import gg.moonflower.pollen.api.fluid.PollinatedFluid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PollinatedLiquidBlock
extends Block
implements BucketPickup {
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61422_;
    public static final VoxelShape STABLE_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private final Supplier<FlowingFluid> fluid;
    private final Supplier<List<FluidState>> stateCache;

    public PollinatedLiquidBlock(Supplier<FlowingFluid> fluid, BlockBehaviour.Properties properties) {
        super(properties);
        this.fluid = fluid;
        this.stateCache = Suppliers.memoize(() -> {
            FlowingFluid flowingFluid = (FlowingFluid)fluid.get();
            ArrayList<FluidState> list = new ArrayList<FluidState>();
            list.add(flowingFluid.m_76068_(false));
            for (int i = 1; i < 8; ++i) {
                list.add(flowingFluid.m_75953_(8 - i, false));
            }
            list.add(flowingFluid.m_75953_(8, true));
            return list;
        });
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public PollinatedLiquidBlock(FlowingFluid fluid, BlockBehaviour.Properties properties) {
        this(() -> fluid, properties);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return context.m_6513_(STABLE_SHAPE, pos, true) && (Integer)state.m_61143_((Property)LEVEL) == 0 && context.m_203682_(level.m_6425_(pos.m_7494_()), state.m_60819_()) ? STABLE_SHAPE : Shapes.m_83040_();
    }

    public boolean m_6724_(BlockState state) {
        return state.m_60819_().m_76187_();
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        state.m_60819_().m_76174_((Level)level, pos, random);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return !this.getFluid().m_205067_(FluidTags.f_13132_);
    }

    public FluidState m_5888_(BlockState state) {
        return this.stateCache.get().get(Math.min((Integer)state.m_61143_((Property)LEVEL), 8));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction direction) {
        return adjacentBlockState.m_60819_().m_76152_().m_6212_((Fluid)this.getFluid());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return Collections.emptyList();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.shouldSpreadLiquid(level, pos)) {
            level.m_186469_(pos, state.m_60819_().m_76152_(), this.getFluid().m_6718_((LevelReader)level));
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (state.m_60819_().m_76170_() || neighborState.m_60819_().m_76170_()) {
            level.m_186469_(currentPos, state.m_60819_().m_76152_(), this.getFluid().m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.shouldSpreadLiquid(level, pos)) {
            level.m_186469_(pos, state.m_60819_().m_76152_(), this.getFluid().m_6718_((LevelReader)level));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEVEL});
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)LEVEL) == 0) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            return new ItemStack((ItemLike)this.getFluid().m_6859_());
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return this.getFluid().m_142520_();
    }

    public FlowingFluid getFluid() {
        return this.fluid.get();
    }

    protected boolean shouldSpreadLiquid(Level level, BlockPos pos) {
        Direction[] directions;
        if (!(this.fluid instanceof PollinatedFluid)) {
            return true;
        }
        PollinatedFluid behavior = (PollinatedFluid)((Object)this.fluid);
        FluidState fluidState = level.m_6425_(pos);
        for (Direction direction : directions = behavior.getInteractionDirections()) {
            BlockPos blockPos = pos.m_142300_(direction);
            BlockState interactionState = behavior.getInteractionState(level, fluidState, pos, blockPos);
            if (interactionState == null) continue;
            level.m_46597_(pos, interactionState);
            behavior.playInteractionEffect(level, fluidState, pos);
            return false;
        }
        return true;
    }
}

