/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.util;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class SkinHelper {
    private static final Map<GameProfile, CompletableFuture<GameProfile>> PROFILE_CACHE = new WeakHashMap<GameProfile, CompletableFuture<GameProfile>>();
    private static MinecraftSessionService sessionService;
    private static GameProfileCache gameProfileCache;

    private SkinHelper() {
    }

    @ApiStatus.Internal
    public static void init() {
        YggdrasilAuthenticationService authenticationservice = new YggdrasilAuthenticationService(Minecraft.m_91087_().m_91096_());
        sessionService = authenticationservice.createMinecraftSessionService();
        gameProfileCache = new GameProfileCache(authenticationservice.createProfileRepository(), new File(Minecraft.m_91087_().f_91069_, MinecraftServer.f_129742_.getName()));
    }

    private static CompletableFuture<GameProfile> guiUpdateGameProfile(GameProfile input) {
        if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
            return CompletableFuture.completedFuture(input);
        }
        if (StringUtil.m_14408_((String)input.getName()) && input.getId() == null) {
            return CompletableFuture.completedFuture(input);
        }
        return CompletableFuture.supplyAsync(() -> {
            if (StringUtil.m_14408_((String)input.getName())) {
                Optional optional = gameProfileCache.m_11002_(input.getId());
                if (optional.isEmpty()) {
                    return input;
                }
                GameProfile profile = (GameProfile)optional.get();
                Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
                if (property == null) {
                    profile = sessionService.fillProfileProperties(profile, true);
                }
                return profile;
            }
            Optional optional = gameProfileCache.m_10996_(input.getName());
            if (optional.isEmpty()) {
                return input;
            }
            GameProfile profile = (GameProfile)optional.get();
            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            if (property == null) {
                profile = sessionService.fillProfileProperties(profile, true);
            }
            return profile;
        }, Util.m_183991_());
    }

    private static CompletableFuture<GameProfile> updateGameProfileFuture(GameProfile input) {
        CompletableFuture<GameProfile> future = new CompletableFuture<GameProfile>();
        SkullBlockEntity.m_155738_((GameProfile)input, future::complete);
        return future;
    }

    @Nullable
    public static synchronized CompletableFuture<GameProfile> updateGameProfile(@Nullable GameProfile input) {
        if (input == null) {
            return null;
        }
        if (Minecraft.m_91087_().f_91073_ == null || StringUtil.m_14408_((String)input.getName())) {
            return PROFILE_CACHE.computeIfAbsent(input, SkinHelper::guiUpdateGameProfile);
        }
        return PROFILE_CACHE.computeIfAbsent(input, SkinHelper::updateGameProfileFuture);
    }

    public static void loadPlayerTexture(@Nullable GameProfile input, MinecraftProfileTexture.Type type, Consumer<ResourceLocation> consumer) {
        CompletableFuture.runAsync(() -> {
            if (input == null) {
                consumer.accept(DefaultPlayerSkin.m_118626_());
                return;
            }
            Map map = Minecraft.m_91087_().m_91109_().m_118815_(input);
            if (map.containsKey(type)) {
                RenderSystem.m_69879_(() -> consumer.accept(Minecraft.m_91087_().m_91109_().m_118825_((MinecraftProfileTexture)map.get(type), type)));
            } else {
                consumer.accept(DefaultPlayerSkin.m_118627_((UUID)Player.m_36198_((GameProfile)input)));
            }
        }, Util.m_183991_());
    }
}

