/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class GrindstoneRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private String group;
    private int experience;

    public GrindstoneRecipeBuilder(ItemLike result, int count) {
        this.result = result.m_5456_();
        this.count = count;
    }

    public static GrindstoneRecipeBuilder grindstone(ItemLike result) {
        return new GrindstoneRecipeBuilder(result, 1);
    }

    public static GrindstoneRecipeBuilder grindstone(ItemLike result, int count) {
        return new GrindstoneRecipeBuilder(result, count);
    }

    public GrindstoneRecipeBuilder requires(TagKey<Item> tag) {
        return this.requires(Ingredient.m_204132_(tag));
    }

    public GrindstoneRecipeBuilder requires(ItemLike item) {
        return this.requires(item, 1);
    }

    public GrindstoneRecipeBuilder requires(ItemLike item, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }
        return this;
    }

    public GrindstoneRecipeBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public GrindstoneRecipeBuilder requires(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public GrindstoneRecipeBuilder unlockedBy(String string, CriterionTriggerInstance criterionTriggerInstance) {
        this.advancement.m_138386_(string, criterionTriggerInstance);
        return this;
    }

    public GrindstoneRecipeBuilder group(String string) {
        this.group = string;
        return this;
    }

    public GrindstoneRecipeBuilder experience(int experience) {
        this.experience = experience;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Registry.f_122827_.m_7981_((Object)this.result));
    }

    public void save(Consumer<FinishedRecipe> consumer, String string) {
        ResourceLocation resourceLocation = Registry.f_122827_.m_7981_((Object)this.result);
        if (new ResourceLocation(string).equals((Object)resourceLocation)) {
            throw new IllegalStateException("Grindstone Recipe " + string + " should remove its 'save' argument");
        }
        this.save(consumer, new ResourceLocation(string));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation resourceLocation) {
        this.ensureValid(resourceLocation);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)resourceLocation)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)resourceLocation)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(resourceLocation, this.result, this.count, this.group == null ? "" : this.group, this.experience, this.ingredients, this.advancement, new ResourceLocation(resourceLocation.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + resourceLocation.m_135815_())));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final int experience;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Item result, int count, String group, int experience, List<Ingredient> ingredients, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.experience = experience;
            this.ingredients = ingredients;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.experience != 0) {
                json.addProperty("experience", (Number)this.experience);
            }
            JsonArray jsonArray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonArray.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)jsonArray);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Registry.f_122827_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
        }

        public RecipeSerializer<?> m_6637_() {
            return PollenRecipeTypes.GRINDSTONE.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

