/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.datagen.provider.SimpleConditionalDataProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PollinatedAdvancementProvider
extends SimpleConditionalDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public PollinatedAdvancementProvider(DataGenerator generator) {
        this.generator = generator;
    }

    protected abstract void registerAdvancements(Consumer<Advancement> var1);

    public void m_6865_(HashCache cache) {
        Path folder = this.generator.m_123916_();
        HashSet set = new HashSet();
        Consumer<Advancement> registry = advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            Path path = PollinatedAdvancementProvider.createPath(folder, advancement);
            JsonObject json = advancement.m_138313_().m_138400_();
            this.injectConditions(advancement.m_138327_(), json);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)json, (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save advancement {}", (Object)path, (Object)e);
            }
        };
        this.registerAdvancements(registry);
    }

    private static Path createPath(Path path, Advancement advancement) {
        return path.resolve("data/" + advancement.m_138327_().m_135827_() + "/advancements/" + advancement.m_138327_().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Advancements";
    }
}

