/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider.loot_table;

import com.google.common.collect.Sets;
import gg.moonflower.pollen.api.datagen.provider.loot_table.PollinatedLootGenerator;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import gg.moonflower.pollen.core.mixin.loot.BlockLootAccessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public abstract class PollinatedBlockLootGenerator
extends BlockLoot
implements PollinatedLootGenerator {
    private final String domain;

    public PollinatedBlockLootGenerator(PollinatedModContainer container) {
        this.domain = container.getId();
    }

    protected abstract void run();

    protected Collection<Block> blocks() {
        return Registry.f_122824_.m_6566_().stream().filter(name -> name.m_135827_().equals(this.domain)).map(arg_0 -> ((DefaultedRegistry)Registry.f_122824_).m_7745_(arg_0)).collect(Collectors.toSet());
    }

    @Override
    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> registry) {
        this.run();
        Map<ResourceLocation, LootTable.Builder> map = ((BlockLootAccessor)((Object)this)).getMap();
        HashSet set = Sets.newHashSet();
        Collection<Block> blocks = this.blocks();
        for (Block block : blocks) {
            ResourceLocation resourceLocation = block.m_60589_();
            if (resourceLocation == BuiltInLootTables.f_78712_ || !set.add(resourceLocation)) continue;
            LootTable.Builder builder = map.remove(resourceLocation);
            if (builder == null) {
                throw new IllegalStateException(String.format("Missing loottable '%s' for '%s'", resourceLocation, Registry.f_122824_.m_7981_((Object)block)));
            }
            registry.accept(resourceLocation, builder);
        }
        if (!map.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + map.keySet());
        }
    }
}

