/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider.loot_table;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import gg.moonflower.pollen.api.datagen.provider.loot_table.PollinatedLootGenerator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PollinatedLootTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<LootContextParamSet, Set<PollinatedLootGenerator>> lootGenerators = new HashMap<LootContextParamSet, Set<PollinatedLootGenerator>>();
    private final DataGenerator generator;

    public PollinatedLootTableProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) {
        Path outputFolder = this.generator.m_123916_();
        HashMap<ResourceLocation, LootTable> lootTables = new HashMap<ResourceLocation, LootTable>();
        this.lootGenerators.forEach((paramSet, lootGenerators) -> {
            BiConsumer<ResourceLocation, LootTable.Builder> registry = (name, builder) -> {
                if (lootTables.put((ResourceLocation)name, builder.m_79165_(paramSet).m_79167_()) != null) {
                    throw new IllegalStateException("Duplicate loot table " + name);
                }
            };
            lootGenerators.forEach(generator -> generator.accept(registry));
        });
        ValidationContext validationContext = new ValidationContext(LootContextParamSets.f_81420_, resourceLocationx -> null, lootTables::get);
        lootTables.forEach((name, lootTable) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)name, (LootTable)lootTable));
        Multimap problems = validationContext.m_79352_();
        if (!problems.isEmpty()) {
            problems.forEach((subject, description) -> LOGGER.warn("Found validation problem in " + subject + ": " + description));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        lootTables.forEach((name, lootTable) -> {
            Path path = PollinatedLootTableProvider.createPath(outputFolder, name);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save loot table {}", (Object)path, (Object)e);
            }
        });
    }

    public PollinatedLootTableProvider add(LootContextParamSet paramSet, PollinatedLootGenerator generator) {
        this.lootGenerators.computeIfAbsent(paramSet, __ -> new HashSet()).add(generator);
        return this;
    }

    private static Path createPath(Path path, ResourceLocation id) {
        return path.resolve("data/" + id.m_135827_() + "/loot_tables/" + id.m_135815_() + ".json");
    }

    public String m_6055_() {
        return "LootTables";
    }
}

